/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.compute.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.compute.FlavorService;
import cn.xphsc.openstack.core.client.compute.ServerService;
import cn.xphsc.openstack.core.client.network.FloatingIpService;
import cn.xphsc.openstack.core.client.network.NetworkService;
import cn.xphsc.openstack.core.entity.compute.Failure;
import cn.xphsc.openstack.core.entity.compute.ImageType;
import cn.xphsc.openstack.core.entity.compute.InterfaceAttachmentPort;
import cn.xphsc.openstack.core.entity.compute.Link;
import cn.xphsc.openstack.core.entity.compute.PowerStateType;
import cn.xphsc.openstack.core.entity.compute.Server;
import cn.xphsc.openstack.core.entity.compute.ServerAddress;
import cn.xphsc.openstack.core.entity.compute.ServerInstanceAction;
import cn.xphsc.openstack.core.entity.compute.ServerStatus;
import cn.xphsc.openstack.core.entity.network.FloatingIp;
import cn.xphsc.openstack.core.entity.network.Network;
import cn.xphsc.openstack.core.exception.OpenstackException;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.core.query.ServerBody;
import cn.xphsc.openstack.core.support.HeatServer;
import cn.xphsc.openstack.core.support.ResourceWaiting;
import cn.xphsc.openstack.utils.CollectionUtils;
import cn.xphsc.openstack.utils.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openstack4j.api.Builders;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.Action;
import org.openstack4j.model.compute.Address;
import org.openstack4j.model.compute.BDMDestType;
import org.openstack4j.model.compute.BDMSourceType;
import org.openstack4j.model.compute.BlockDeviceMappingCreate;
import org.openstack4j.model.compute.Flavor;
import org.openstack4j.model.compute.Image;
import org.openstack4j.model.compute.InstanceAction;
import org.openstack4j.model.compute.InterfaceAttachment;
import org.openstack4j.model.compute.RebootType;
import org.openstack4j.model.compute.SecurityGroup;
import org.openstack4j.model.compute.Server;
import org.openstack4j.model.compute.ServerCreate;
import org.openstack4j.model.compute.ServerUpdateOptions;
import org.openstack4j.model.compute.VNCConsole;
import org.openstack4j.model.compute.actions.RebuildOptions;
import org.openstack4j.model.compute.builder.ServerCreateBuilder;
import org.openstack4j.model.compute.ext.Hypervisor;
import org.openstack4j.model.image.v2.Image;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.model.storage.block.Volume;
import org.openstack4j.model.storage.block.VolumeSnapshot;
import org.openstack4j.openstack.compute.domain.NovaBlockDeviceMappingCreate;
import org.openstack4j.openstack.compute.domain.NovaServerCreate;
import org.springframework.stereotype.Component;

@Component
public class ServerServiceImpl
implements ServerService {
    private final OpenstackTemplate openstackTemplate;
    private final FlavorService flavorService;
    private final NetworkService networkService;
    private final FloatingIpService floatingIpService;

    public ServerServiceImpl(OpenstackTemplate openstackTemplate, FlavorService flavorService, NetworkService networkService, FloatingIpService floatingIpService) {
        this.openstackTemplate = openstackTemplate;
        this.flavorService = flavorService;
        this.networkService = networkService;
        this.floatingIpService = floatingIpService;
    }

    @Override
    public List<Server> list() {
        return this.listByName(null);
    }

    @Override
    public List<Server> listServer() {
        LinkedList<Server> serverList = new LinkedList<Server>();
        List opsServerList = this.openstackTemplate.compute().servers().list();
        for (org.openstack4j.model.compute.Server opsServer : opsServerList) {
            serverList.add(this.translateServer(opsServer, null, null));
        }
        return serverList;
    }

    @Override
    public Page<Server> list(PageQuery pageQuery) {
        List<Server> servers = this.listByName(pageQuery.getName());
        return PageImpl.of(servers, pageQuery.getOffset(), pageQuery.getLimit());
    }

    @Override
    public List<Server> list(Map<String, String> filteringParams) {
        LinkedList<Server> serverList = new LinkedList<Server>();
        List opsServerList = this.openstackTemplate.compute().servers().list(filteringParams);
        for (org.openstack4j.model.compute.Server opsServer : opsServerList) {
            serverList.add(this.translateServer(opsServer, null, null));
        }
        return serverList;
    }

    @Override
    public Server get(String serverId) {
        org.openstack4j.model.compute.Server opsServer = this.openstackTemplate.compute().servers().get(serverId);
        if (Objects.isNull(opsServer)) {
            return null;
        }
        return this.translateServer(opsServer, null, null);
    }

    @Override
    public Server create(ServerBody serverBody) {
        org.openstack4j.model.compute.Server server;
        ServerCreate serverCreate = this.toServerCreate(serverBody);
        try {
            server = this.openstackTemplate.compute().servers().boot(serverCreate);
        }
        catch (ClientResponseException var8) {
            throw new OpenstackException(var8.getMessage(), var8);
        }
        String serverId = server.getId();
        Boolean isConfigFloatIp = serverBody.getConfigFloatIp();
        String externalNetworkName = serverBody.getExternalNetworkName();
        if (isConfigFloatIp != null && isConfigFloatIp.booleanValue() && !Strings.isEmpty(externalNetworkName)) {
            FloatingIp floatingIp = this.floatingIpService.create(externalNetworkName);
            ResourceWaiting.waitForResource(() -> this.openstackTemplate.compute().servers().get(serverId), newestServer -> HeatServer.isActive(newestServer), this.openstackTemplate.getConnectionTimeout(), this.openstackTemplate.getIntervalTime());
            this.bindFloatIp(serverId, floatingIp.getFloatingIpAddress());
        }
        Server startServer = this.translateServer(server, null, null);
        return startServer;
    }

    @Override
    public int update(String serverId, String name) {
        try {
            ServerUpdateOptions options = ServerUpdateOptions.create();
            options.name(name);
            this.openstackTemplate.compute().servers().update(serverId, options);
        }
        catch (ClientResponseException var4) {
            return 0;
        }
        return 1;
    }

    @Override
    public int delete(String serverId) {
        this.releaseServerFloatingIp(serverId);
        ActionResponse response = this.openstackTemplate.compute().servers().delete(serverId);
        if (!response.isSuccess()) {
            ResourceWaiting.waitForResource(() -> this.openstackTemplate.compute().servers().get(serverId), this.openstackTemplate.getWaitTimeout(), this.openstackTemplate.getIntervalTime());
        }
        return response.isSuccess() ? 1 : 0;
    }

    @Override
    public int resize(String serverId, String flavorId) {
        ActionResponse response = this.openstackTemplate.compute().servers().resize(serverId, flavorId);
        return response.isSuccess() ? 1 : 0;
    }

    @Override
    public int confirmResize(String serverId) {
        ActionResponse response = this.openstackTemplate.compute().servers().confirmResize(serverId);
        return response.isSuccess() ? 1 : 0;
    }

    @Override
    public int revertResize(String serverId) {
        ActionResponse response = this.openstackTemplate.compute().servers().revertResize(serverId);
        return response.isSuccess() ? 1 : 0;
    }

    @Override
    public int action(String serverId, Action action) {
        ActionResponse response = this.openstackTemplate.compute().servers().action(serverId, action);
        return response.isSuccess() ? 1 : 0;
    }

    @Override
    public int rebuild(String serverId) {
        org.openstack4j.model.compute.Server server = this.openstackTemplate.compute().servers().get(serverId);
        RebuildOptions rebuildOptions = RebuildOptions.create();
        rebuildOptions.adminPass(server.getAdminPass());
        rebuildOptions.name(server.getName());
        rebuildOptions.image(server.getImageId());
        ActionResponse response = this.openstackTemplate.compute().servers().rebuild(serverId, rebuildOptions);
        return response.isSuccess() ? 1 : 0;
    }

    @Override
    public int reboot(String serverId) {
        ActionResponse response = this.openstackTemplate.compute().servers().reboot(serverId, RebootType.SOFT);
        return response.isSuccess() ? 1 : 0;
    }

    @Override
    public int boot(String serverId) {
        ActionResponse actionResponse = this.openstackTemplate.compute().servers().action(serverId, Action.START);
        return actionResponse.isSuccess() ? 1 : 0;
    }

    @Override
    public int shutDown(String serverId) {
        ActionResponse actionResponse = this.openstackTemplate.compute().servers().action(serverId, Action.STOP);
        return actionResponse.isSuccess() ? 1 : 0;
    }

    @Override
    public String vncConsole(String serverId) {
        VNCConsole console = this.openstackTemplate.compute().servers().getVNCConsole(serverId, VNCConsole.Type.NOVNC);
        return console.getURL();
    }

    @Override
    public int bindFloatIp(String serverId, String floatIp) {
        ActionResponse actionResponse = this.openstackTemplate.compute().floatingIps().addFloatingIP(serverId, floatIp);
        return actionResponse.isSuccess() ? 1 : 0;
    }

    @Override
    public int unbindFloatIp(String serverId) {
        org.openstack4j.model.compute.Server server = this.openstackTemplate.compute().servers().get(serverId);
        Map address = server.getAddresses().getAddresses();
        for (Map.Entry entry : address.entrySet()) {
            List addrList = (List)entry.getValue();
            for (Address addressData : addrList) {
                String type = addressData.getType();
                if (Strings.equals(type, "fixed")) continue;
                String floatIp = addressData.getAddr();
                ActionResponse actionResponse = this.openstackTemplate.compute().floatingIps().removeFloatingIP(server, floatIp);
                if (actionResponse.isSuccess()) continue;
                return 0;
            }
        }
        return 1;
    }

    @Override
    public int updateSecurityGroup(String serverId, String secGroupName) {
        ActionResponse delActResp;
        String oriSecGroupName;
        org.openstack4j.model.compute.Server server = this.openstackTemplate.compute().servers().get(serverId);
        String string = oriSecGroupName = CollectionUtils.isEmpty(server.getSecurityGroups()) ? null : ((SecurityGroup)server.getSecurityGroups().get(0)).getName();
        if (Strings.equals(oriSecGroupName, secGroupName)) {
            return 0;
        }
        if (!Strings.isEmpty(oriSecGroupName) && !(delActResp = this.openstackTemplate.compute().servers().removeSecurityGroup(serverId, ((SecurityGroup)server.getSecurityGroups().get(0)).getName())).isSuccess()) {
            return 0;
        }
        delActResp = this.openstackTemplate.compute().servers().addSecurityGroup(serverId, secGroupName);
        return delActResp.isSuccess() ? 1 : 0;
    }

    @Override
    public String snapshot(String serverId, String snapshotName) {
        org.openstack4j.model.compute.Server opsServer = this.openstackTemplate.compute().servers().get(serverId);
        if (!Objects.isNull(opsServer) && !CollectionUtils.isEmpty(opsServer.getOsExtendedVolumesAttached())) {
            String volumeId = (String)opsServer.getOsExtendedVolumesAttached().get(0);
            VolumeSnapshot volumeSnapshot = (VolumeSnapshot)Builders.volumeSnapshot().volume(volumeId).force(true).name(snapshotName).build();
            volumeSnapshot = this.openstackTemplate.blockStorage().snapshots().create(volumeSnapshot);
            return Objects.nonNull(volumeSnapshot) ? volumeSnapshot.getId() : null;
        }
        org.openstack4j.model.image.v2.Image imageSnapshot = this.createImageSnapshot(serverId, snapshotName);
        if (!Objects.isNull(imageSnapshot) && Image.ImageStatus.ACTIVE.equals((Object)imageSnapshot.getStatus())) {
            return imageSnapshot.getId();
        }
        return null;
    }

    public org.openstack4j.model.image.v2.Image createImageSnapshot(String serverId, String snapshotName) {
        String snapshotId = this.openstackTemplate.compute().servers().createSnapshot(serverId, snapshotName);
        return ResourceWaiting.waitForResource(() -> this.openstackTemplate.imagesV2().get(snapshotId), snapshot -> !Image.ImageStatus.QUEUED.equals((Object)snapshot.getStatus()), this.openstackTemplate.getWaitTimeout(), this.openstackTemplate.getIntervalTime());
    }

    @Override
    public List<InterfaceAttachmentPort> listInterfaceAttachmentPort(String serverId) {
        List interfaceAttachments = this.openstackTemplate.compute().servers().interfaces().list(serverId);
        LinkedList<InterfaceAttachmentPort> interfaceAttachmentPortList = new LinkedList<InterfaceAttachmentPort>();
        LinkedList<InterfaceAttachmentPort.FixedIp> fixedIps = new LinkedList<InterfaceAttachmentPort.FixedIp>();
        for (InterfaceAttachment interfaceAttachment : interfaceAttachments) {
            List opsfFixedIps = interfaceAttachment.getFixedIps();
            if (CollectionUtils.isNotEmpty(opsfFixedIps)) {
                for (InterfaceAttachment.FixedIp opsfFixedIp : opsfFixedIps) {
                    InterfaceAttachmentPort.FixedIp fixedIp = InterfaceAttachmentPort.FixedIp.builder().ipAddress(opsfFixedIp.getIpAddress()).subnetId(opsfFixedIp.getSubnetId()).build();
                    fixedIps.add(fixedIp);
                }
            }
            InterfaceAttachmentPort interfaceAttachmentPort = InterfaceAttachmentPort.builder().portId(interfaceAttachment.getPortId()).fixedIps(fixedIps).macAddr(interfaceAttachment.getMacAddr()).portState(InterfaceAttachmentPort.PortState.valueOf(interfaceAttachment.getPortState().name())).netId(interfaceAttachment.getNetId()).build();
            interfaceAttachmentPortList.add(interfaceAttachmentPort);
        }
        return interfaceAttachmentPortList;
    }

    @Override
    public Object changeTime(String serverId, String requestedTime, String requestedTimeZone) {
        return ServerService.super.changeTime(serverId, requestedTime, requestedTimeZone);
    }

    @Override
    public Server waitForServerStatus(String serverId, ServerStatus serverStatus, int maxWait, TimeUnit maxWaitUnit) {
        org.openstack4j.model.compute.Server opsServer = this.openstackTemplate.compute().servers().waitForServerStatus(serverId, Server.Status.forValue((String)serverStatus.name()), maxWait, maxWaitUnit);
        return this.translateServer(opsServer, null, null);
    }

    @Override
    public String consoleOutput(String serverId, int numLines) {
        return this.openstackTemplate.compute().servers().getConsoleOutput(serverId, numLines);
    }

    @Override
    public int resetState(String serverId, ServerStatus serverStatus) {
        ActionResponse actionResponse = this.openstackTemplate.compute().servers().resetState(serverId, Server.Status.forValue((String)serverStatus.name()));
        return actionResponse.isSuccess() ? 1 : 0;
    }

    @Override
    public List<ServerInstanceAction> listInstanceAction(String serverId) {
        List instanceActions = this.openstackTemplate.compute().servers().instanceActions().list(serverId);
        ArrayList serverInstanceActions = Lists.newArrayList();
        for (InstanceAction instanceAction : instanceActions) {
            serverInstanceActions.add(this.translateServerInstanceAction(instanceAction));
        }
        return serverInstanceActions;
    }

    @Override
    public ServerInstanceAction instanceAction(String serverId, String requestId) {
        InstanceAction instanceAction = this.openstackTemplate.compute().servers().instanceActions().get(serverId, requestId);
        return this.translateServerInstanceAction(instanceAction);
    }

    @Override
    public Object writeFile(String serverId, String filePath, String fileContent) {
        return ServerService.super.writeFile(serverId, filePath, fileContent);
    }

    @Override
    public String readFile(String serverId, String filePath) {
        return ServerService.super.readFile(serverId, filePath);
    }

    @Override
    public boolean checkAppContainer(String containerId) {
        return ServerService.super.checkAppContainer(containerId);
    }

    @Override
    public Object writeAppContainerFile(String containerId, String containerPath, String fileName, String fileContent) {
        return ServerService.super.writeAppContainerFile(containerId, containerPath, fileName, fileContent);
    }

    @Override
    public String readAppContainerFile(String containerId, String filePath) {
        return ServerService.super.readAppContainerFile(containerId, filePath);
    }

    private List<Server> listByName(String name) {
        HashMap<String, String> filteringParams = new HashMap<String, String>(1);
        if (Strings.isNotBlank(name)) {
            filteringParams.put("name", name);
        }
        Map<String, String> volumeImageMap = this.getVolumeImageMap();
        Map<String, String> hostMap = this.getHostMap();
        List opsServerList = new ArrayList();
        opsServerList = this.openstackTemplate.compute().servers().list(filteringParams);
        LinkedList<Server> serverList = new LinkedList<Server>();
        for (org.openstack4j.model.compute.Server opsServer : opsServerList) {
            String hostIp = hostMap.get(opsServer.getHost());
            String imageId = opsServer.getImageId();
            Image image = Strings.isEmpty(imageId) && !CollectionUtils.isEmpty(opsServer.getOsExtendedVolumesAttached()) ? (Strings.isEmpty(imageId = volumeImageMap.get(opsServer.getOsExtendedVolumesAttached().get(0))) ? null : this.openstackTemplate.compute().images().get(imageId)) : (opsServer.getImage() != null ? opsServer.getImage() : null);
            Server server = this.translateServer(opsServer, hostIp, image == null ? "" : image.getName());
            serverList.add(server);
        }
        return serverList;
    }

    private Server translateServer(org.openstack4j.model.compute.Server opsServer, String hostIp, String imageName) {
        Flavor cloudFlavor;
        if (Objects.isNull(opsServer)) {
            return null;
        }
        Server.Builder builder = Server.builder();
        builder.name(opsServer.getName());
        builder.imageId(opsServer.getImageId());
        builder.flavorId(opsServer.getFlavorId());
        builder.keypairName(opsServer.getKeyName());
        if (opsServer.getAddresses() != null) {
            this.setServerAddr(opsServer.getAddresses().getAddresses(), builder);
        }
        builder.powerState(opsServer.getPowerState());
        if (opsServer.getPowerState() != null) {
            builder.powerStateType(PowerStateType.fromCode(Integer.valueOf(opsServer.getPowerState())));
        }
        if (opsServer.getStatus() != null) {
            builder.status(opsServer.getStatus().name());
        }
        if (opsServer.getCreated() != null) {
            String runningTime = this.getInstanceRunTime(opsServer.getCreated());
            builder.runningTime(runningTime);
        }
        builder.hostIp(StringUtils.isNotEmpty((CharSequence)hostIp) ? hostIp : opsServer.getHost());
        builder.taskState(opsServer.getTaskState());
        if (CollectionUtils.isNotEmpty(opsServer.getLinks())) {
            LinkedList<Link> links = new LinkedList<Link>();
            for (org.openstack4j.model.common.Link lin : opsServer.getLinks()) {
                Link.Builder link = new Link.Builder();
                link.type(lin.getType());
                link.href(lin.getHref());
                link.rel(lin.getRel());
                links.add(link.build());
            }
            builder.links(links);
        }
        List opSecurityGroups = opsServer.getSecurityGroups();
        ArrayList<String> securityGroups = new ArrayList<String>();
        Optional.ofNullable(opSecurityGroups).ifPresent(osg -> securityGroups.addAll(osg.stream().map(SecurityGroup::getName).collect(Collectors.toList())));
        builder.securityGroups(securityGroups);
        Failure.Builder failure = Failure.builder();
        if (Objects.nonNull(opsServer.getFault())) {
            if (Strings.isNotBlank(opsServer.getFault().getMessage())) {
                failure.message(opsServer.getFault().getMessage());
            }
            if (Strings.isNotBlank(opsServer.getFault().getDetails())) {
                failure.details(opsServer.getFault().getDetails());
            }
            if (opsServer.getFault().getCreated() != null) {
                failure.created(opsServer.getFault().getCreated());
            }
            if (opsServer.getFault().getCode() != 0) {
                failure.code(opsServer.getFault().getCode());
            }
        }
        builder.failure(failure.build());
        builder.fault(Objects.nonNull(opsServer.getFault()) ? opsServer.getFault().getMessage() : null);
        builder.serverStatus(opsServer.getStatus() != null ? ServerStatus.fromValue(opsServer.getStatus().name()) : null);
        if (opsServer.getFlavorId() != null && !Objects.isNull(cloudFlavor = this.openstackTemplate.compute().flavors().get(opsServer.getFlavorId()))) {
            cn.xphsc.openstack.core.entity.compute.Flavor flavor = cn.xphsc.openstack.core.entity.compute.Flavor.builder().swap(cloudFlavor.getSwap()).name(cloudFlavor.getName()).ephemeral(cloudFlavor.getEphemeral()).ram(cloudFlavor.getRam()).vcpus(cloudFlavor.getVcpus()).disk(cloudFlavor.getDisk()).isPublic(cloudFlavor.isPublic()).build();
            builder.flavor(flavor);
        }
        builder.image(imageName);
        Server server = builder.build();
        server.setId(opsServer.getId());
        return server;
    }

    private Map<String, String> getHostMap() {
        List hypervisors = this.openstackTemplate.compute().hypervisors().list();
        return hypervisors.stream().collect(Collectors.toMap(Hypervisor::getHypervisorHostname, Hypervisor::getHostIP));
    }

    private Map<String, String> getVolumeImageMap() {
        List volumeList = this.openstackTemplate.blockStorage().volumes().list();
        return volumeList.stream().filter(item -> Strings.isNotBlank(item.getImageRef())).collect(Collectors.toMap(Volume::getId, Volume::getImageRef));
    }

    private String getInstanceRunTime(Date created) {
        long currentTime = System.currentTimeMillis();
        long createTime = created.getTime();
        long runTimeSec = (currentTime - createTime) / 1000L;
        long years = runTimeSec / 31536000L;
        long months = (runTimeSec %= 31536000L) / 2592000L;
        long weeks = (runTimeSec %= 2592000L) / 604800L;
        long days = (runTimeSec %= 604800L) / 86400L;
        long hours = (runTimeSec %= 86400L) / 3600L;
        long minutes = (runTimeSec %= 3600L) / 60L;
        StringBuilder result = new StringBuilder();
        if (years > 0L) {
            result.append(years).append(" years ");
            if (months > 0L) {
                result.append(months).append(" months");
            }
            return result.toString().trim();
        }
        if (months > 0L) {
            result.append(months).append(" months ");
            if (days > 0L) {
                result.append(days).append(" days");
            }
            return result.toString().trim();
        }
        if (weeks > 0L) {
            result.append(weeks).append(" weeks ");
            if (days > 0L) {
                result.append(days).append(" days");
            }
            return result.toString().trim();
        }
        if (days > 0L) {
            result.append(days).append(" days ");
            if (hours > 0L) {
                result.append(hours).append(" hours");
            }
            return result.toString().trim();
        }
        result.append(hours).append(" hours ");
        result.append(minutes).append(" minutes");
        return result.toString().trim();
    }

    private void setServerAddr(Map<String, List<? extends Address>> addresses, Server.Builder ServerBuilder) {
        Iterator<Map.Entry<String, List<? extends Address>>> iter = addresses.entrySet().iterator();
        LinkedList<ServerAddress> serverAddressList = new LinkedList<ServerAddress>();
        while (iter.hasNext()) {
            Map.Entry<String, List<? extends Address>> entry = iter.next();
            List<? extends Address> addressList = entry.getValue();
            String key = entry.getKey();
            for (Address address : addressList) {
                ServerAddress.Builder builder = ServerAddress.builder();
                builder.addr(address.getAddr());
                builder.mac(address.getMacAddr());
                builder.version(address.getVersion());
                builder.network(key);
                if (Strings.equals(address.getType(), "fixed")) {
                    builder.type("fixed");
                } else {
                    builder.type("float-ip");
                }
                ServerAddress serverAddress = builder.build();
                serverAddressList.add(serverAddress);
            }
        }
        ServerBuilder.address(serverAddressList);
    }

    private ServerCreate toServerCreate(ServerBody serverStart) {
        List<Object> networkIds;
        String imageId = this.getImageId(serverStart);
        cn.xphsc.openstack.core.entity.compute.Flavor flavor = this.flavorService.getByName(serverStart.getFlavor());
        List<Object> list = networkIds = Objects.isNull(serverStart.getNetworkIds()) ? new ArrayList() : serverStart.getNetworkIds();
        if (Strings.isNotEmpty(serverStart.getNetworkName())) {
            Network network = this.networkService.getByName(serverStart.getNetworkName());
            Optional.ofNullable(network).ifPresent(net -> networkIds.add(net.getId()));
        }
        ServerCreateBuilder builder = NovaServerCreate.builder().name(serverStart.getName()).availabilityZone(serverStart.getAvailabilityZone()).networks(networkIds).configDrive(Boolean.FALSE.booleanValue()).flavor(flavor.getId());
        if (CollectionUtils.isNotEmpty(serverStart.getSecGroupNameList())) {
            serverStart.getSecGroupNameList().forEach(arg_0 -> ((ServerCreateBuilder)builder).addSecurityGroup(arg_0));
        }
        builder.keypairName(serverStart.getKeypairName());
        if (!ImageType.IMAGE.equals((Object)serverStart.getImageType()) && !ImageType.SNAPSHOT.equals((Object)serverStart.getImageType())) {
            boolean deleteOnTermination = Objects.isNull(serverStart.getDeleteOnTermination()) || serverStart.getDeleteOnTermination() != false;
            builder.blockDevice((BlockDeviceMappingCreate)NovaBlockDeviceMappingCreate.builder().sourceType(BDMSourceType.SNAPSHOT).deleteOnTermination(deleteOnTermination).bootIndex(0).uuid(imageId).destinationType(BDMDestType.VOLUME).build());
        } else {
            builder.image(imageId);
        }
        if (Strings.isNotEmpty(serverStart.getScript())) {
            builder.userData(Base64.getEncoder().encodeToString(serverStart.getScript().getBytes()));
        }
        return (ServerCreate)builder.build();
    }

    private String getImageId(ServerBody serverStart) {
        org.openstack4j.model.image.v2.Image image;
        String imageId = serverStart.getImageId();
        if (Strings.isEmpty(imageId) && Objects.nonNull(image = this.getImageByName(serverStart.getImage()))) {
            imageId = image.getId();
        }
        if (!ImageType.IMAGE.equals((Object)serverStart.getImageType()) && !ImageType.SNAPSHOT.equals((Object)serverStart.getImageType())) {
            VolumeSnapshot volumeSnapshot = this.getVolumeSnapshot(serverStart.getImage());
            String volumeSnapshotId = null;
            if (Objects.nonNull(volumeSnapshot)) {
                volumeSnapshotId = volumeSnapshot.getId();
            }
            return Strings.isNotEmpty(volumeSnapshotId) ? volumeSnapshotId : imageId;
        }
        if (Strings.isNotEmpty(imageId)) {
            return imageId;
        }
        throw new OpenstackException(String.format("image %s does not exist", serverStart.getImage()));
    }

    private org.openstack4j.model.image.v2.Image getImageByName(String name) {
        HashMap<String, String> filteringParams = new HashMap<String, String>();
        filteringParams.put("name", name);
        filteringParams.put("owner", this.openstackTemplate.token().getProject().getId());
        List imageList = this.openstackTemplate.imagesV2().list(filteringParams);
        return CollectionUtils.isNotEmpty(imageList) ? (org.openstack4j.model.image.v2.Image)imageList.get(0) : null;
    }

    private VolumeSnapshot getVolumeSnapshot(String name) {
        List volumeSnapshots = this.openstackTemplate.blockStorage().snapshots().list();
        Optional<VolumeSnapshot> optional = volumeSnapshots.stream().filter(volumeSnapshot -> Strings.equals(name, volumeSnapshot.getName())).findFirst();
        return !optional.isPresent() ? null : optional.get();
    }

    private ServerInstanceAction translateServerInstanceAction(InstanceAction instanceAction) {
        ServerInstanceAction serverInstanceAction = ServerInstanceAction.builder().action(instanceAction.getAction()).instanceUuid(instanceAction.getInstanceUuid()).message(instanceAction.getMessage()).projectId(instanceAction.getProjectId()).requestId(instanceAction.getRequestId()).userId(instanceAction.getUserId()).build();
        return serverInstanceAction;
    }

    private void releaseServerFloatingIp(String serverId) {
        List floatingIpAddresses;
        org.openstack4j.model.compute.Server opsServer = this.openstackTemplate.compute().servers().get(serverId);
        if (opsServer != null && !CollectionUtils.isEmpty(floatingIpAddresses = opsServer.getAddresses().getAddresses().values().stream().flatMap(Collection::stream).filter(address -> !"fixed".equals(address.getType())).map(Address::getAddr).collect(Collectors.toList()))) {
            List netFloatingIps = this.openstackTemplate.networking().floatingip().list().stream().filter(netFloatingIP -> floatingIpAddresses.contains(netFloatingIP.getFloatingIpAddress())).collect(Collectors.toList());
            for (NetFloatingIP netFloatingIp : netFloatingIps) {
                this.floatingIpService.disassociateFromPort(netFloatingIp.getId());
                this.floatingIpService.delete(netFloatingIp.getId());
            }
        }
    }
}

