/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.compute.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.compute.SnapshotService;
import cn.xphsc.openstack.core.entity.compute.Snapshot;
import cn.xphsc.openstack.core.support.ResourceWaiting;
import java.util.Objects;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.block.VolumeSnapshot;
import org.springframework.stereotype.Component;

@Component
public class SnapshotServiceImpl
implements SnapshotService {
    private final OpenstackTemplate openstackTemplate;

    public SnapshotServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public int deleteById(String snapshotId) {
        ActionResponse actionResponse = this.openstackTemplate.blockStorage().snapshots().delete(snapshotId);
        return !actionResponse.isSuccess() ? 1 : 0;
    }

    public int deleteSnapshotAndVolume(String snapshotId) {
        VolumeSnapshot volumeSnapshot = this.openstackTemplate.blockStorage().snapshots().get(snapshotId);
        if (Objects.nonNull(volumeSnapshot)) {
            this.openstackTemplate.blockStorage().snapshots().delete(snapshotId);
            VolumeSnapshot snapshot = ResourceWaiting.waitForResource(() -> this.openstackTemplate.blockStorage().snapshots().get(snapshotId), this.openstackTemplate.getWaitTimeout(), this.openstackTemplate.getIntervalTime());
            if (Objects.nonNull(snapshot)) {
                return 0;
            }
            this.openstackTemplate.blockStorage().volumes().delete(volumeSnapshot.getVolumeId());
        }
        return 1;
    }

    @Override
    public Snapshot get(String snapshotId) {
        VolumeSnapshot volumeSnapshot = this.openstackTemplate.blockStorage().snapshots().get(snapshotId);
        if (Objects.isNull(volumeSnapshot)) {
            return null;
        }
        Snapshot snapshot = Snapshot.builder().name(volumeSnapshot.getName()).size(volumeSnapshot.getSize()).status(Snapshot.StatusEnum.fromValue(volumeSnapshot.getStatus().name())).build();
        snapshot.setId(volumeSnapshot.getId());
        return snapshot;
    }
}

