/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.container.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.Apis;
import cn.xphsc.openstack.core.client.container.AppcontainerQuotaService;
import cn.xphsc.openstack.core.client.container.ContainerQuotaSetService;
import cn.xphsc.openstack.core.entity.container.AppcontainerQuotaSetUsage;
import cn.xphsc.openstack.core.entity.container.ContainerQuotaSetUsage;
import org.springframework.stereotype.Component;

@Component
public class ContainerQuotaSetServiceImpl
implements ContainerQuotaSetService {
    private final OpenstackTemplate openstackTemplate;

    public ContainerQuotaSetServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public ContainerQuotaSetUsage getUsage() {
        AppcontainerQuotaSetUsage appcontainerQuotaSetUsage = this.getAppcontainerQuotaService().getUsage(this.openstackTemplate.token().getProject().getId());
        return this.translateContainer(appcontainerQuotaSetUsage);
    }

    private ContainerQuotaSetUsage translateContainer(AppcontainerQuotaSetUsage usage) {
        return ContainerQuotaSetUsage.builder().cpuLimit(usage.getCpu().getLimit()).cpuInUse(usage.getCpu().getInUse()).diskLimit(usage.getDisk().getLimit()).diskInUse(usage.getDisk().getInUse()).memoryLimit(usage.getMemory().getLimit()).memoryInUse(usage.getMemory().getInUse()).containersLimit(usage.getContainers().getLimit()).containersInUse(usage.getContainers().getInUse()).build();
    }

    public AppcontainerQuotaService getAppcontainerQuotaService() {
        return Apis.appContainerQuotaService();
    }
}

