/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.heat.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.heat.ResourcesService;
import cn.xphsc.openstack.core.entity.heat.Resource;
import cn.xphsc.openstack.core.query.ResourceQuery;
import cn.xphsc.openstack.utils.Strings;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ResourcesServiceImpl
implements ResourcesService {
    private final OpenstackTemplate openstackTemplate;

    public ResourcesServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public List<Resource> list(ResourceQuery resourceQuery) {
        return this.translateResource(resourceQuery);
    }

    private List<Resource> translateResource(ResourceQuery resourceQuery) {
        List resources = null;
        resources = Strings.isBlank(resourceQuery.getStackNameOrId()) ? this.openstackTemplate.heat().resources().list(resourceQuery.getStackName(), resourceQuery.getStackId()) : (Strings.isNotBlank(resourceQuery.getStackNameOrId()) && resourceQuery.getDepth() != 0 ? this.openstackTemplate.heat().resources().list(resourceQuery.getStackNameOrId(), resourceQuery.getDepth()) : this.openstackTemplate.heat().resources().list(resourceQuery.getStackNameOrId()));
        List<Resource> resourceList = resources.stream().map(rece -> {
            Resource.Builder resource = Resource.builder();
            resource.localReourceId(rece.getLocalReourceId());
            resource.resourceName(rece.getResourceName());
            resource.resourceStatus(rece.getResourceStatus());
            resource.physicalResourceId(rece.getPhysicalResourceId());
            resource.reason(rece.getReason());
            resource.requiredBy(rece.getRequiredBy());
            resource.time(rece.getTime());
            return resource.build();
        }).collect(Collectors.toList());
        return resourceList;
    }
}

