/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.heat.service;

import cn.xphsc.openstack.boot.autoconfigure.CloudClientExternalProperties;
import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.heat.StackTemplateService;
import cn.xphsc.openstack.core.entity.heat.StackInput;
import cn.xphsc.openstack.core.support.ResourceRenderer;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import org.openstack4j.api.Builders;
import org.openstack4j.api.heat.StackService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.heat.Stack;
import org.openstack4j.model.heat.StackCreate;
import org.openstack4j.model.heat.StackUpdate;
import org.openstack4j.model.heat.builder.StackCreateBuilder;
import org.springframework.stereotype.Component;

@Component
public class StackTemplateServiceImpl
implements StackTemplateService {
    private final OpenstackTemplate openstackTemplate;
    private final CloudClientExternalProperties cloudClientExternalNetProperties;

    public StackTemplateServiceImpl(OpenstackTemplate openstackTemplate, CloudClientExternalProperties cloudClientExternalNetProperties) {
        this.openstackTemplate = openstackTemplate;
        this.cloudClientExternalNetProperties = cloudClientExternalNetProperties;
    }

    @Override
    public Stack createStack(StackInput stackInput) {
        Preconditions.checkNotNull((Object)stackInput.getName());
        Preconditions.checkState((Strings.isNullOrEmpty((String)stackInput.getTemplate()) || Strings.isNullOrEmpty((String)stackInput.getTemplateURL()) || Strings.isNullOrEmpty((String)stackInput.getTemplateFileName()) ? 1 : 0) != 0);
        StackCreateBuilder builder = Builders.stack().name(stackInput.getName()).parameters(stackInput.getParameters()).disableRollback(false);
        if (!Strings.isNullOrEmpty((String)stackInput.getTemplateFileName())) {
            String path = ResourceRenderer.resourcePath(this.cloudClientExternalNetProperties.getTemplatePath());
            String tplFileLoacation = Joiner.on((String)"/").skipNulls().join((Object)path, (Object)stackInput.getTemplateFileName(), new Object[0]);
            builder.templateFromFile(tplFileLoacation);
        } else if (!Strings.isNullOrEmpty((String)stackInput.getTemplateURL())) {
            builder.templateURL(stackInput.getTemplateURL());
        } else {
            if (Strings.isNullOrEmpty((String)stackInput.getTemplate())) {
                return (Stack)Collections.emptyList();
            }
            builder.template(stackInput.getTemplate());
        }
        builder.timeoutMins(Long.valueOf(Long.valueOf(0L).equals(stackInput.getTimeout()) ? 1L : stackInput.getTimeout()));
        return this.openstackTemplate.heat().stacks().create((StackCreate)builder.build());
    }

    @Override
    public Stack getStackByName(String stackName) {
        return this.openstackTemplate.heat().stacks().getStackByName(stackName);
    }

    @Override
    public ActionResponse deleteStack(Stack stack) {
        Preconditions.checkNotNull((Object)stack);
        return this.openstackTemplate.heat().stacks().delete(stack.getName(), stack.getId());
    }

    @Override
    public ActionResponse deleteStack(String stackName, String stackId) {
        StackService stacks = this.openstackTemplate.heat().stacks();
        ActionResponse response = stacks.delete(stackName, stackId);
        if (!response.isSuccess()) {
            response = stacks.delete(stackName, stackId);
        }
        return response;
    }

    @Override
    public ActionResponse updateStack(String stackId, String stackName, String template) {
        StackUpdate stackUpdate = (StackUpdate)Builders.stackUpdate().template(template).build();
        return this.openstackTemplate.heat().stacks().update(stackName, stackId, stackUpdate);
    }
}

