/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.network.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.network.FloatingIpService;
import cn.xphsc.openstack.core.client.network.NetworkService;
import cn.xphsc.openstack.core.entity.network.FloatingIp;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.utils.CollectionUtils;
import cn.xphsc.openstack.utils.Strings;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstack4j.api.Builders;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.builder.NetFloatingIPBuilder;
import org.springframework.stereotype.Component;

@Component
public class FloatingIpServiceImpl
implements FloatingIpService {
    private final OpenstackTemplate openstackTemplate;
    private final NetworkService networkService;

    public FloatingIpServiceImpl(OpenstackTemplate openstackTemplate, NetworkService networkService) {
        this.openstackTemplate = openstackTemplate;
        this.networkService = networkService;
    }

    @Override
    public FloatingIp get(String floatingIpId) {
        NetFloatingIP netFloatingIP = this.openstackTemplate.networking().floatingip().get(floatingIpId);
        String networkName = this.networkService.get(netFloatingIP.getFloatingNetworkId()).getName();
        return this.translateFloatingIp(netFloatingIP, networkName);
    }

    @Override
    public FloatingIp getByFixedIpAddress(String fixedIpAddress) {
        HashMap filteringParams = Maps.newHashMapWithExpectedSize((int)1);
        filteringParams.put("fixed_ip_address", fixedIpAddress);
        List netFloatingIPs = this.openstackTemplate.networking().floatingip().list((Map)filteringParams);
        if (CollectionUtils.isNotEmpty(netFloatingIPs)) {
            NetFloatingIP netFloatingIP = (NetFloatingIP)netFloatingIPs.get(0);
            return this.translateFloatingIp(netFloatingIP, null);
        }
        return null;
    }

    @Override
    public List<FloatingIp> list() {
        return this.listByPageQuery(null);
    }

    @Override
    public Page<FloatingIp> list(PageQuery pageQuery) {
        List<FloatingIp> floatingIps = this.listByPageQuery(pageQuery);
        return PageImpl.of(floatingIps, pageQuery.getOffset(), pageQuery.getLimit());
    }

    @Override
    public int delete(String floatingIpId) {
        ActionResponse actionResponse = this.openstackTemplate.networking().floatingip().delete(floatingIpId);
        return actionResponse.isSuccess() ? 1 : 0;
    }

    @Override
    public FloatingIp create(String networkName) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("name", networkName);
        List list = this.openstackTemplate.networking().network().list(filter);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        NetFloatingIP netFloatingIP = this.openstackTemplate.networking().floatingip().create((NetFloatingIP)Builders.netFloatingIP().floatingNetworkId(((Network)list.get(0)).getId()).build());
        return this.translateFloatingIp(netFloatingIP, this.networkService.get(netFloatingIP.getFloatingNetworkId()).getName());
    }

    public FloatingIp create(String networkName, String floatingIpAddress) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("name", networkName);
        List list = this.openstackTemplate.networking().network().list(filter);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        NetFloatingIPBuilder netFloatingIPBuilder = Builders.netFloatingIP();
        netFloatingIPBuilder.floatingNetworkId(((Network)list.get(0)).getId());
        NetFloatingIP netFloatingIP = this.openstackTemplate.networking().floatingip().create((NetFloatingIP)netFloatingIPBuilder.build());
        return this.translateFloatingIp(netFloatingIP, this.networkService.get(netFloatingIP.getFloatingNetworkId()).getName());
    }

    @Override
    public FloatingIp create(String networkId, String portId, String floatingIpAddress) {
        NetFloatingIPBuilder netFloatingIPBuilder = Builders.netFloatingIP();
        if (portId != null) {
            netFloatingIPBuilder.portId(portId);
        }
        netFloatingIPBuilder.floatingNetworkId(networkId);
        NetFloatingIP netFloatingIP = this.openstackTemplate.networking().floatingip().create((NetFloatingIP)netFloatingIPBuilder.build());
        return this.translateFloatingIp(netFloatingIP, null);
    }

    @Override
    public FloatingIp associateToPort(String floatingIpId, String portId) {
        NetFloatingIP netFloatingIP = this.openstackTemplate.networking().floatingip().associateToPort(floatingIpId, portId);
        return this.translateFloatingIp(netFloatingIP, null);
    }

    @Override
    public FloatingIp disassociateFromPort(String floatingIpId) {
        NetFloatingIP netFloatingIP = this.openstackTemplate.networking().floatingip().disassociateFromPort(floatingIpId);
        return this.translateFloatingIp(netFloatingIP, null);
    }

    public List<FloatingIp> listByPageQuery(PageQuery pageQuery) {
        List opsFloatIpList = this.openstackTemplate.networking().floatingip().list();
        String queryName = pageQuery == null ? null : pageQuery.getName();
        String queryStatus = pageQuery == null ? null : pageQuery.getStatus();
        opsFloatIpList = opsFloatIpList.stream().filter(opsFloatIpx -> Strings.isEmpty(queryStatus) || queryStatus.equals(opsFloatIpx.getStatus())).filter(opsFloatIpx -> Strings.isEmpty(queryName) || opsFloatIpx.getFloatingIpAddress().contains(queryName)).collect(Collectors.toList());
        Map<String, String> networkIdNameMap = this.openstackTemplate.networking().network().list().stream().collect(Collectors.toMap(network -> network.getId(), network -> network.getName()));
        ArrayList<FloatingIp> floatIpList = new ArrayList<FloatingIp>();
        for (NetFloatingIP opsFloatIp : opsFloatIpList) {
            String networkName = networkIdNameMap.get(opsFloatIp.getFloatingNetworkId());
            floatIpList.add(this.translateFloatingIp(opsFloatIp, networkName));
        }
        return floatIpList;
    }

    private FloatingIp translateFloatingIp(NetFloatingIP opsFloatIp, String networkName) {
        if (Objects.isNull(opsFloatIp)) {
            return null;
        }
        String floatIpAddress = opsFloatIp.getFloatingIpAddress();
        FloatingIp floatIp = FloatingIp.builder().routerId(opsFloatIp.getRouterId()).fixIpAddress(opsFloatIp.getFixedIpAddress()).floatingIpAddress(floatIpAddress).networkId(opsFloatIp.getFloatingNetworkId()).portId(opsFloatIp.getPortId()).status(opsFloatIp.getStatus()).description(opsFloatIp.getDescription() != null ? opsFloatIp.getDescription() : null).networkName(networkName).build();
        floatIp.setTenantId(opsFloatIp.getTenantId());
        floatIp.setId(opsFloatIp.getId());
        return floatIp;
    }
}

