/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.network.service;

import cn.xphsc.openstack.boot.autoconfigure.CloudClientExternalProperties;
import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.network.NetworkService;
import cn.xphsc.openstack.core.client.network.SubnetService;
import cn.xphsc.openstack.core.client.network.service.NetworkExternalService;
import cn.xphsc.openstack.core.entity.network.Network;
import cn.xphsc.openstack.core.entity.network.NetworkType;
import cn.xphsc.openstack.core.entity.network.Subnet;
import cn.xphsc.openstack.core.exception.OpenstackException;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.utils.CollectionUtils;
import cn.xphsc.openstack.utils.Strings;
import cn.xphsc.openstack.utils.net.Cidr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstack4j.api.Builders;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.NetworkUpdate;
import org.openstack4j.model.network.Pool;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.model.network.builder.NetworkUpdateBuilder;
import org.openstack4j.openstack.networking.domain.NeutronNetworkUpdate;
import org.springframework.stereotype.Component;

@Component
public class NetworkServiceImpl
implements NetworkService {
    private final OpenstackTemplate openstackTemplate;
    private final SubnetService subnetService;
    private final NetworkExternalService opsNetworkService;
    private final CloudClientExternalProperties cloudClientExternalProperties;

    public NetworkServiceImpl(OpenstackTemplate openstackTemplate, SubnetService subnetService, NetworkExternalService opsNetworkService, CloudClientExternalProperties cloudClientExternalProperties) {
        this.openstackTemplate = openstackTemplate;
        this.subnetService = subnetService;
        this.opsNetworkService = opsNetworkService;
        this.cloudClientExternalProperties = cloudClientExternalProperties;
    }

    @Override
    public Network get(String networkId) {
        org.openstack4j.model.network.Network network = this.openstackTemplate.networking().network().get(networkId);
        List subnets = network.getNeutronSubnets();
        return this.translateNetwork(network, subnets);
    }

    @Override
    public Network getByName(String name) {
        List<Network> networks = this.listByName(name, false);
        return CollectionUtils.isNotEmpty(networks) ? networks.get(0) : null;
    }

    @Override
    public List<Network> list() {
        return this.listByName(null, false);
    }

    @Override
    public Page<Network> list(PageQuery pageQuery) {
        List<Network> networks = this.listByName(pageQuery.getName(), false);
        return PageImpl.of(networks, pageQuery.getOffset(), pageQuery.getLimit());
    }

    @Override
    public Page<Network> listExternalNetwork(PageQuery cloudPageQuery) {
        List<Network> networks = this.listByName(cloudPageQuery.getName(), true);
        return PageImpl.of(networks, cloudPageQuery.getOffset(), cloudPageQuery.getLimit());
    }

    public List<Network> listByName(String name, boolean isExternal) {
        HashMap<String, String> filter = new HashMap<String, String>();
        if (Boolean.TRUE.equals(isExternal)) {
            filter.put("router:external", "True");
        }
        filter.put("tenant_id", this.openstackTemplate.token().getProject().getId());
        filter.put("shared", "False");
        List opsNetworkList = this.openstackTemplate.networking().network().list(filter);
        filter.remove("tenant_id");
        filter.put("shared", "True");
        List opsNetworkShared = this.openstackTemplate.networking().network().list(filter);
        opsNetworkList.addAll(opsNetworkShared);
        filter.remove("shared");
        filter.put("router:external", "True");
        List opsNetworkExternal = this.openstackTemplate.networking().network().list(filter);
        opsNetworkList.addAll(opsNetworkExternal);
        ArrayList<Network> networkList = new ArrayList<Network>();
        List opsNetworkListDistinct = opsNetworkList.stream().filter(network -> Strings.isEmpty(name) || network.getName().contains(name)).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(opsNetworkListDistinct)) {
            return networkList;
        }
        List opsSubnetList = this.openstackTemplate.networking().subnet().list();
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(opsSubnetList)) {
            map = opsSubnetList.stream().collect(Collectors.groupingBy(subnet -> subnet.getNetworkId()));
        }
        for (org.openstack4j.model.network.Network opsNetwork : opsNetworkListDistinct) {
            networkList.add(this.translateNetwork(opsNetwork, (List)map.get(opsNetwork.getId())));
        }
        return networkList;
    }

    @Override
    public Network create(Network network) {
        org.openstack4j.model.network.Network createNetwork;
        String networkName = network.getName();
        List networkList = this.openstackTemplate.networking().network().list();
        Iterator networkIterator = networkList.iterator();
        do {
            if (networkIterator.hasNext()) continue;
            Network cloudNetwork = null;
            try {
                createNetwork = this.openstackTemplate.networking().network().create((org.openstack4j.model.network.Network)Builders.network().name(networkName).networkType(org.openstack4j.model.network.NetworkType.forValue((String)network.getNetworkType())).segmentId(network.getSegmentId()).physicalNetwork(network.getPhysicalNet()).adminStateUp(network.getAdminStateUp().booleanValue()).build());
                if (Objects.nonNull(createNetwork)) {
                    List neutronSubnets = createNetwork.getNeutronSubnets();
                    cloudNetwork = this.translateNetwork(createNetwork, neutronSubnets);
                    if (CollectionUtils.isNotEmpty(network.getSubnet())) {
                        cn.xphsc.openstack.core.entity.network.Subnet subnet = network.getSubnet().get(0);
                        cn.xphsc.openstack.core.entity.network.Subnet newSubnet = cn.xphsc.openstack.core.entity.network.Subnet.builder().networkId(createNetwork.getId()).cidr(subnet.getCidr()).disableGateway(subnet.getDisableGateway()).dns(subnet.getDns()).enableDhcp(subnet.getEnableDhcp()).gateway(subnet.getGateway()).ipVersion(subnet.getIpVersion()).name(subnet.getName()).pools(subnet.getPools()).build();
                        cn.xphsc.openstack.core.entity.network.Subnet cloudSubnet = this.subnetService.create(newSubnet);
                        cloudNetwork.addSubnetItem(cloudSubnet);
                    }
                }
                return cloudNetwork;
            }
            catch (ClientResponseException var10) {
                throw new OpenstackException(var10);
            }
        } while (!Strings.equals((createNetwork = (org.openstack4j.model.network.Network)networkIterator.next()).getName(), networkName));
        throw new OpenstackException("net.creatErrNetNameExit");
    }

    @Override
    public int update(Network network) {
        try {
            NeutronNetworkUpdate networkUpdate = new NeutronNetworkUpdate();
            ((NetworkUpdateBuilder)networkUpdate.toBuilder()).name(network.getName()).adminStateUp(network.getAdminStateUp().booleanValue());
            this.openstackTemplate.networking().network().update(network.getId(), (NetworkUpdate)networkUpdate);
        }
        catch (ClientResponseException var3) {
            return 0;
        }
        return 1;
    }

    @Override
    public int delete(String networkId) {
        ActionResponse actionResponse = this.openstackTemplate.networking().network().delete(networkId);
        return actionResponse.isSuccess() ? 1 : 0;
    }

    @Override
    public void createExternalNet(cn.xphsc.openstack.core.entity.external.Network net) {
        Cidr cidr = com.google.common.base.Strings.isNullOrEmpty((String)net.getCidr()) ? this.cloudClientExternalProperties.defaultCidrOfVlan(net.getId()) : Cidr.of(net.getCidr());
        org.openstack4j.model.network.Network vlanNetwork = this.opsNetworkService.findVlanNetwork(net.getVlanId(), cidr, net.getPhysicalNetwork(), CollectionUtils.isNotEmpty(net.getAllocationPools()) ? net.getAllocationPools().get(0).getStart() : null, CollectionUtils.isNotEmpty(net.getAllocationPools()) ? net.getAllocationPools().get(0).getEnd() : null, net.getDhcp());
        net.setId(vlanNetwork.getId());
        net.setNetworkType(NetworkType.VLAN);
        if (Optional.ofNullable(vlanNetwork.getNeutronSubnets()).isPresent()) {
            Subnet subnet = (Subnet)vlanNetwork.getNeutronSubnets().stream().findFirst().get();
            net.setCidr(subnet.getCidr());
            net.setGateway(subnet.getGateway());
            net.setAllocationPools(subnet.getAllocationPools().stream().map(pool -> {
                cn.xphsc.openstack.core.entity.network.Pool newPool = cn.xphsc.openstack.core.entity.network.Pool.builder().build();
                newPool.setStart(pool.getStart());
                newPool.setEnd(pool.getEnd());
                return newPool;
            }).collect(Collectors.toList()));
        }
    }

    private Network translateNetwork(org.openstack4j.model.network.Network opsNetwork, List<? extends Subnet> subnets) {
        if (Objects.isNull(opsNetwork)) {
            return null;
        }
        Network network = Network.builder().name(opsNetwork.getName()).isShared(opsNetwork.isShared()).isExternal(opsNetwork.isRouterExternal()).status(opsNetwork.getStatus().toString()).isAdminStateUp(opsNetwork.isAdminStateUp()).type(NetworkType.fromValue(opsNetwork.getNetworkType().toString())).availabilityZones(opsNetwork.getAvailabilityZones()).networkType(opsNetwork.getNetworkType().name()).vlan(opsNetwork.getProviderSegID()).subnet(this.setCidrAndSubNet(subnets)).portSecurityEnabled(opsNetwork.isPortSecurityEnabled() != null ? opsNetwork.isPortSecurityEnabled() : true).physicalNet(opsNetwork.getProviderPhyNet()).build();
        network.setId(opsNetwork.getId());
        network.setTenantId(opsNetwork.getTenantId());
        return network;
    }

    private List<cn.xphsc.openstack.core.entity.network.Subnet> setCidrAndSubNet(List<? extends Subnet> opsSubnets) {
        if (!CollectionUtils.isEmpty(opsSubnets)) {
            ArrayList<cn.xphsc.openstack.core.entity.network.Subnet> subnetList = new ArrayList<cn.xphsc.openstack.core.entity.network.Subnet>(opsSubnets.size());
            for (Subnet subnet : opsSubnets) {
                Subnet.Builder subnet2 = new Subnet.Builder();
                subnet2.name(subnet.getName());
                subnet2.cidr(subnet.getCidr());
                subnet2.dns(subnet.getDnsNames());
                subnet2.networkId(subnet.getNetworkId());
                subnet2.enableDhcp(subnet.isDHCPEnabled());
                subnet2.gateway(subnet.getGateway());
                subnet2.ipVersion(subnet.getIpVersion().getVersion());
                ArrayList<cn.xphsc.openstack.core.entity.network.Pool> pools = new ArrayList<cn.xphsc.openstack.core.entity.network.Pool>();
                Pool pool = (Pool)subnet.getAllocationPools().get(0);
                cn.xphsc.openstack.core.entity.network.Pool newPool = cn.xphsc.openstack.core.entity.network.Pool.builder().build();
                newPool.setStart(pool.getStart());
                newPool.setEnd(pool.getEnd());
                pools.add(newPool);
                subnet2.pools(pools);
                cn.xphsc.openstack.core.entity.network.Subnet sunet = subnet2.build();
                sunet.setId(subnet.getId());
                sunet.setTenantId(subnet.getTenantId());
                subnetList.add(sunet);
            }
            return subnetList;
        }
        return null;
    }
}

