/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.network.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.network.PortService;
import cn.xphsc.openstack.core.entity.network.Port;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.utils.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openstack4j.api.Builders;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.model.network.builder.PortBuilder;
import org.openstack4j.model.network.options.PortListOptions;
import org.openstack4j.openstack.networking.domain.NeutronIP;
import org.springframework.stereotype.Component;

@Component
public class PortServiceImpl
implements PortService {
    private final OpenstackTemplate openstackTemplate;

    public PortServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public List<Port> list(String routerId) {
        PortListOptions options = PortListOptions.create();
        options.deviceId(routerId);
        List opsPorts = this.openstackTemplate.networking().port().list(options);
        ArrayList<Port> ports = new ArrayList<Port>();
        for (org.openstack4j.model.network.Port opsPort : opsPorts) {
            ports.add(this.translatePort(opsPort));
        }
        return ports;
    }

    @Override
    public List<Port> list() {
        List opsPorts = this.openstackTemplate.networking().port().list();
        ArrayList<Port> ports = new ArrayList<Port>();
        for (org.openstack4j.model.network.Port opsPort : opsPorts) {
            ports.add(this.translatePort(opsPort));
        }
        return ports;
    }

    @Override
    public List<Port> listPort(String networkId) {
        PortListOptions options = PortListOptions.create();
        options.networkId(networkId);
        List opsPorts = this.openstackTemplate.networking().port().list(options);
        ArrayList<Port> ports = new ArrayList<Port>();
        for (org.openstack4j.model.network.Port opsPort : opsPorts) {
            ports.add(this.translatePort(opsPort));
        }
        return ports;
    }

    @Override
    public Page<Port> list(PageQuery pageQuery, String routerId) {
        List<Port> portList = this.list(routerId);
        return PageImpl.of(portList, pageQuery.getOffset(), pageQuery.getLimit());
    }

    @Override
    public Port get(String portId) {
        return this.translatePort(this.openstackTemplate.networking().port().get(portId));
    }

    @Override
    public int create(String routerId, String networkId, String subnetId, String fixedIp) {
        try {
            Subnet subnet = this.openstackTemplate.networking().subnet().get(subnetId);
            if (Strings.isEmpty(fixedIp)) {
                String cidr = subnet.getCidr();
                fixedIp = cidr.substring(0, cidr.indexOf(47) + 1);
                fixedIp = fixedIp.replace("0/", "1");
            }
            this.openstackTemplate.networking().port().create((org.openstack4j.model.network.Port)Builders.port().deviceId(routerId).networkId(subnet.getNetworkId()).fixedIp(fixedIp, subnetId).build());
        }
        catch (ClientResponseException var7) {
            return 0;
        }
        return 1;
    }

    @Override
    public int create(Port port) {
        String fixedIp = null;
        try {
            Subnet subnet = this.openstackTemplate.networking().subnet().get(port.getSubnetId());
            if (Strings.isEmpty(port.getFixedIp())) {
                String cidr = subnet.getCidr();
                fixedIp = cidr.substring(0, cidr.indexOf(47) + 1);
                fixedIp = fixedIp.replace("0/", "1");
            }
            PortBuilder portBuilder = Builders.port();
            portBuilder.deviceId(port.getRouterId());
            portBuilder.networkId(subnet.getNetworkId());
            portBuilder.fixedIp(fixedIp, port.getSubnetId());
            if (port.getAdminStateUp() != null) {
                portBuilder.adminState(port.getAdminStateUp().booleanValue());
            }
            if (Strings.isNotBlank(port.getName())) {
                portBuilder.name(port.getName());
            }
            if (Strings.isNotBlank(port.getMacAddress())) {
                portBuilder.macAddress(port.getMacAddress());
            }
            if (Strings.isNotBlank(port.getStatus())) {
                portBuilder.name(port.getStatus());
            }
            this.openstackTemplate.networking().port().create((org.openstack4j.model.network.Port)portBuilder.build());
        }
        catch (ClientResponseException var7) {
            return 0;
        }
        return 1;
    }

    @Override
    public Port update(Port port) {
        PortBuilder builder = Builders.port();
        if (Objects.nonNull(port.getPortSecurity())) {
            builder.portSecurityEnabled(port.getPortSecurity());
        }
        builder.adminState(port.getAdminStateUp().booleanValue());
        org.openstack4j.model.network.Port opPort = (org.openstack4j.model.network.Port)builder.build();
        opPort.setId(port.getId());
        opPort.setName(port.getName());
        org.openstack4j.model.network.Port opsPort = this.openstackTemplate.networking().port().update(opPort);
        return this.translatePort(opsPort);
    }

    @Override
    public int delete(String portId) {
        ActionResponse actionResponse = this.openstackTemplate.networking().port().delete(portId);
        return actionResponse.isSuccess() ? 1 : 0;
    }

    private Port translatePort(org.openstack4j.model.network.Port opsPort) {
        if (Objects.isNull(opsPort)) {
            return null;
        }
        List<NeutronIP> neutronIps = this.getNeutronIps(opsPort);
        Port port = Port.builder().name(opsPort.getName()).networkId(opsPort.getNetworkId()).adminStateUp(opsPort.isAdminStateUp()).macAddress(opsPort.getMacAddress()).fixedIp(neutronIps.get(0).getIpAddress()).device(opsPort.getDeviceOwner()).trunkPortType(opsPort.getTrunkPortType()).vifType(opsPort.getVifType() != null ? opsPort.getVifType() : null).vNicType(opsPort.getvNicType() != null ? opsPort.getvNicType() : null).status(opsPort.getState() != null ? opsPort.getState().name() : null).build();
        port.setId(opsPort.getId());
        return port;
    }

    private List<NeutronIP> getNeutronIps(org.openstack4j.model.network.Port opsPort) {
        Set fixedIp = opsPort.getFixedIps();
        Iterator iterator = fixedIp.iterator();
        ArrayList<NeutronIP> neutronIps = new ArrayList<NeutronIP>();
        while (iterator.hasNext()) {
            neutronIps.add((NeutronIP)iterator.next());
        }
        return neutronIps;
    }
}

