/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.statistics.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.container.ContainerQuotaSetService;
import cn.xphsc.openstack.core.client.network.SecurityGroupService;
import cn.xphsc.openstack.core.client.statistics.ResourceStatisticsService;
import cn.xphsc.openstack.core.entity.container.ContainerQuotaSetUsage;
import cn.xphsc.openstack.core.entity.statistics.HostInfo;
import cn.xphsc.openstack.core.entity.statistics.ResourceLimitStatistics;
import cn.xphsc.openstack.core.entity.statistics.ResourceStateWithTime;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openstack4j.api.compute.QuotaSetService;
import org.openstack4j.model.common.QuotaDetails;
import org.openstack4j.model.compute.AbsoluteLimit;
import org.openstack4j.model.compute.SimpleTenantUsage;
import org.openstack4j.model.compute.ext.Hypervisor;
import org.openstack4j.model.network.NetQuota;
import org.springframework.stereotype.Component;

@Component
public class ResourceStatisticsServiceImpl
implements ResourceStatisticsService {
    private final OpenstackTemplate openstackTemplate;
    private final ContainerQuotaSetService containerQuotaSetService;
    private final SecurityGroupService securityGroupService;

    public ResourceStatisticsServiceImpl(OpenstackTemplate openstackTemplate, ContainerQuotaSetService containerQuotaSetService, SecurityGroupService securityGroupService) {
        this.openstackTemplate = openstackTemplate;
        this.containerQuotaSetService = containerQuotaSetService;
        this.securityGroupService = securityGroupService;
    }

    @Override
    public List<HostInfo> hostInfo() {
        List hypervisors = this.openstackTemplate.compute().hypervisors().list();
        ArrayList<HostInfo> hostInfoList = new ArrayList<HostInfo>();
        for (Hypervisor hypervisor : hypervisors) {
            HostInfo hostInfo = HostInfo.builder().id(hypervisor.getId()).name(hypervisor.getHypervisorHostname()).ip(hypervisor.getHostIP()).totalMemory(hypervisor.getLocalMemory()).usedMemory(hypervisor.getLocalMemoryUsed()).usedVcpu(hypervisor.getVirtualUsedCPU()).status(hypervisor.getState()).totalStorage(hypervisor.getLocalDisk()).usedStorage(hypervisor.getLocalDiskUsed()).runningServers(hypervisor.getRunningVM()).build();
            hostInfoList.add(hostInfo);
        }
        return hostInfoList;
    }

    @Override
    public ResourceLimitStatistics usedStatistics() {
        AbsoluteLimit absoluteLimit = this.openstackTemplate.compute().quotaSets().limits().getAbsolute();
        QuotaDetails gigabytes = this.openstackTemplate.blockStorage().quotaSets().usageForTenant(this.openstackTemplate.token().getProject().getId()).getGigabytes();
        ResourceLimitStatistics.Builder builder = ResourceLimitStatistics.builder();
        builder.totalServer(absoluteLimit.getMaxTotalInstances()).usedServer(absoluteLimit.getTotalInstancesUsed()).totalVcpu(absoluteLimit.getMaxTotalCores()).usedVcpu(absoluteLimit.getTotalCoresUsed()).totalMemory(this.getRamGB(absoluteLimit.getMaxTotalRAMSize())).usedMemory(this.getRamGB(absoluteLimit.getTotalRAMUsed())).totalVolumeStorage(gigabytes.getLimit()).usedVolumeStorage(gigabytes.getInUse()).build();
        String projectId = this.openstackTemplate.token().getProject().getId();
        NetQuota quota = this.openstackTemplate.networking().quotas().get(projectId);
        int totalFloatingIpsUsed = this.openstackTemplate.networking().floatingip().list(this.filterByTenant(projectId)).size();
        builder.totalFloatingIp(quota.getFloatingIP());
        builder.usedFloatingIp(totalFloatingIpsUsed);
        int totalSecurityGroupUsed = this.securityGroupService.list().size();
        builder.totalSecurityGroup(quota.getSecurityGroup());
        builder.usedSecurityGroup(totalSecurityGroupUsed);
        ContainerQuotaSetUsage containerQuotaSetUsage = this.containerQuotaSetService.getUsage();
        builder.totalContainer(containerQuotaSetUsage.getContainersLimit());
        builder.usedContainer(containerQuotaSetUsage.getContainersInUse());
        return builder.build();
    }

    @Override
    public List<ResourceStateWithTime> resourceDynamicStatistics(Integer type) {
        List<ResourceStateWithTime> timeList = this.getTimeListByType(type);
        timeList = this.putUsage(timeList);
        return timeList;
    }

    private Map<String, String> filterByTenant(String projectId) {
        return Collections.singletonMap("tenant_id", projectId);
    }

    private String getRamGB(int ram) {
        if (ram == -1) {
            return "-1";
        }
        String toGB = String.valueOf((float)Math.round((float)ram * 10.0f / 1024.0f) / 10.0f);
        if (toGB.indexOf(46) >= 0) {
            toGB = toGB.replaceAll("0+?$", "");
            toGB = toGB.replaceAll("[.]$", "");
        }
        return toGB;
    }

    private List<ResourceStateWithTime> putUsage(List<ResourceStateWithTime> timeList) {
        ArrayList<ResourceStateWithTime> resourceStateWithTimeList = new ArrayList<ResourceStateWithTime>(timeList.size());
        String projectId = this.openstackTemplate.token().getProject().getId();
        QuotaSetService quotaSetService = this.openstackTemplate.compute().quotaSets();
        AbsoluteLimit limit = quotaSetService.limits().getAbsolute();
        int totalCpu = limit.getMaxTotalCores();
        int totalRam = limit.getMaxTotalRAMSize();
        int totalGb = 0;
        List hypervisors = this.openstackTemplate.compute().hypervisors().list();
        for (Hypervisor hypervisor : hypervisors) {
            totalGb += hypervisor.getLocalDisk();
        }
        totalGb = totalGb == 0 ? 1 : totalGb;
        for (ResourceStateWithTime resourceStateWithTime : timeList) {
            Optional<SimpleTenantUsage> usage = Optional.ofNullable(quotaSetService.getTenantUsage(projectId, resourceStateWithTime.getStartTime(), resourceStateWithTime.getEndTime()));
            double hours = resourceStateWithTime.getStep() == 10 ? (double)Math.round((double)resourceStateWithTime.getStep().intValue() * 100.0 / 60.0) / 100.0 : (double)resourceStateWithTime.getStep().intValue();
            double hour = Double.parseDouble(Double.toString(hours));
            double cpuRate = this.rateOf(totalCpu, hour, usage.map(SimpleTenantUsage::getTotalVcpusUsage));
            double gbRate = this.rateOf(totalGb, hour, usage.map(SimpleTenantUsage::getTotalLocalGbUsage));
            double ramRate = this.rateOf(totalRam, hour, usage.map(SimpleTenantUsage::getTotalMemoryMbUsage));
            ResourceStateWithTime resourcesTime = ResourceStateWithTime.builder().step(resourceStateWithTime.getStep()).ramRate(BigDecimal.valueOf(ramRate)).diskRate(BigDecimal.valueOf(gbRate)).vcpuRate(BigDecimal.valueOf(cpuRate)).startTime(this.formatTime(resourceStateWithTime.getStartTime())).endTime(this.formatTime(resourceStateWithTime.getEndTime())).build();
            resourceStateWithTimeList.add(resourcesTime);
        }
        return resourceStateWithTimeList;
    }

    private String formatTime(String openstackTime) {
        openstackTime = openstackTime.replace("T", " ");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        try {
            date = sdf.parse(openstackTime);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, 8);
        return sdf.format(cal.getTime());
    }

    private double rateOf(int total, double hour, Optional<BigDecimal> usage) {
        return usage.map(BigDecimal::doubleValue).map(value -> (double)Math.round(value * 10000.0 / (double)total / hour) / 100.0).orElse(0.0);
    }

    private List<ResourceStateWithTime> getTimeListByType(Integer type) {
        int step = 0;
        int amount = 0;
        int unit = 0;
        switch (type) {
            case 0: {
                step = 10;
                amount = 6;
                unit = 12;
                break;
            }
            case 1: {
                step = 4;
                amount = 7;
                unit = 10;
                break;
            }
            case 2: {
                step = 24;
                amount = 7;
                unit = 10;
            }
        }
        return this.getTimeList(step, amount, unit);
    }

    private List<ResourceStateWithTime> getTimeList(int step, int amount, int unit) {
        ArrayList<ResourceStateWithTime> timeList = new ArrayList<ResourceStateWithTime>();
        Calendar cal = Calendar.getInstance();
        cal.add(10, -8);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < amount; ++i) {
            String endTime = sdf.format(cal.getTime()).replace(" ", "T");
            cal.add(unit, -1 * step);
            String startTime = sdf.format(cal.getTime()).replace(" ", "T");
            ResourceStateWithTime resourceStateWithTime = ResourceStateWithTime.builder().startTime(startTime).endTime(endTime).step(step).build();
            timeList.add(resourceStateWithTime);
        }
        return timeList;
    }
}

