/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.entity.compute;

import java.util.Date;

public class ServerInstanceAction {
    private String action;
    private String instanceUuid;
    private String message;
    private String projectId;
    private String requestId;
    private Date startTime;
    private String userId;

    public static Builder builder() {
        return new Builder();
    }

    private ServerInstanceAction(Builder builder) {
        this.action = builder.action;
        this.instanceUuid = builder.instanceUuid;
        this.message = builder.message;
        this.projectId = builder.projectId;
        this.requestId = builder.requestId;
        this.startTime = builder.startTime;
        this.userId = builder.userId;
    }

    public String getAction() {
        return this.action;
    }

    public String getInstanceUuid() {
        return this.instanceUuid;
    }

    public String getMessage() {
        return this.message;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getUserId() {
        return this.userId;
    }

    public static class Builder {
        private String action;
        private String instanceUuid;
        private String message;
        private String projectId;
        private String requestId;
        private Date startTime;
        private String userId;

        public <T> Builder action(String action) {
            this.action = action;
            return this;
        }

        public <T> Builder instanceUuid(String instanceUuid) {
            this.instanceUuid = instanceUuid;
            return this;
        }

        public <T> Builder message(String message) {
            this.message = message;
            return this;
        }

        public <T> Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public <T> Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public <T> Builder requestId(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public <T> Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public ServerInstanceAction build() {
            return new ServerInstanceAction(this);
        }
    }
}

