/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.entity.heat;

import java.util.Map;

public class StackInput {
    private String stackId;
    private String name;
    private Long timeout;
    private String template;
    private String templateFileName;
    private String templateURL;
    private Map<String, String> parameters;
    private String tags;

    public StackInput() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private StackInput(Builder builder) {
        this.stackId = builder.stackId;
        this.name = builder.name;
        this.timeout = builder.timeout;
        this.template = builder.template;
        this.templateFileName = builder.templateFileName;
        this.templateURL = builder.templateURL;
        this.parameters = builder.parameters;
        this.tags = builder.tags;
    }

    public String getStackId() {
        return this.stackId;
    }

    public String getName() {
        return this.name;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public String getTemplateURL() {
        return this.templateURL;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getTags() {
        return this.tags;
    }

    public String toString() {
        return "{name=" + this.name + ", timeout=" + this.timeout + ", parameters=" + this.parameters + ", template=" + this.template + "}";
    }

    public static class Builder {
        private String name;
        private Long timeout;
        private String template;
        private String templateFileName;
        private String templateURL;
        private Map<String, String> parameters;
        private String tags;
        private String stackId;

        public <T> Builder name(String name) {
            this.name = name;
            return this;
        }

        public <T> Builder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public <T> Builder template(String template) {
            this.template = template;
            return this;
        }

        public <T> Builder templateFileName(String templateFileName) {
            this.templateFileName = templateFileName;
            return this;
        }

        public <T> Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public <T> Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public <T> Builder tags(String tags) {
            this.tags = tags;
            return this;
        }

        public <T> Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public StackInput build() {
            return new StackInput(this);
        }
    }
}

