/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.entity.network;

import cn.xphsc.openstack.core.entity.ModelEntity;
import cn.xphsc.openstack.core.entity.network.RouterNet;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class Router
extends ModelEntity {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="is_admin_state_up")
    private Boolean isAdminStateUp = null;
    @JsonProperty(value="availability_zones")
    private List<String> availabilityZones = null;
    @JsonProperty(value="external_network")
    private String externalNetwork = null;
    @JsonProperty(value="external_network_id")
    private String externalNetworkId = null;
    @JsonProperty(value="router_nets")
    private List<RouterNet> routerNets = null;

    public Router() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Router(Builder builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.isAdminStateUp = builder.isAdminStateUp;
        this.availabilityZones = builder.availabilityZones;
        this.externalNetwork = builder.externalNetwork;
        this.externalNetworkId = builder.externalNetworkId;
        this.routerNets = builder.routerNets;
        this.setId(builder.routerId);
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public Boolean getAdminStateUp() {
        return this.isAdminStateUp;
    }

    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public String getExternalNetwork() {
        return this.externalNetwork;
    }

    public String getExternalNetworkId() {
        return this.externalNetworkId;
    }

    public List<RouterNet> getRouterNets() {
        return this.routerNets;
    }

    public static class Builder {
        private String name = null;
        private String routerId = null;
        private String status = null;
        private Boolean isAdminStateUp = null;
        private List<String> availabilityZones = null;
        private String externalNetwork = null;
        private String externalNetworkId = null;
        private List<RouterNet> routerNets = null;

        public <T> Builder routerId(String routerId) {
            this.routerId = routerId;
            return this;
        }

        public <T> Builder name(String name) {
            this.name = name;
            return this;
        }

        public <T> Builder status(String status) {
            this.status = status;
            return this;
        }

        public <T> Builder isAdminStateUp(boolean isAdminStateUp) {
            this.isAdminStateUp = isAdminStateUp;
            return this;
        }

        public <T> Builder availabilityZones(List<String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        public <T> Builder externalNetwork(String externalNetwork) {
            this.externalNetwork = externalNetwork;
            return this;
        }

        public <T> Builder externalNetworkId(String externalNetworkId) {
            this.externalNetworkId = externalNetworkId;
            return this;
        }

        public <T> Builder routerNets(List<RouterNet> routerNets) {
            this.routerNets = routerNets;
            return this;
        }

        public Router build() {
            return new Router(this);
        }
    }
}

