/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.lambda;

import cn.xphsc.openstack.core.exception.OpenstackException;
import cn.xphsc.openstack.core.lambda.LambdaFunction;
import java.beans.Introspector;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class Reflections {
    private static final Pattern GET_PATTERN = Pattern.compile("^get[A-Z].*");
    private static final Pattern IS_PATTERN = Pattern.compile("^is[A-Z].*");

    private Reflections() {
    }

    public static String fieldNameForLambdaFunction(LambdaFunction fn) {
        try {
            Method e = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            e.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)e.invoke((Object)fn, new Object[0]);
            String getter = serializedLambda.getImplMethodName();
            if (GET_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(3);
            } else if (IS_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(2);
            }
            return Introspector.decapitalize(getter);
        }
        catch (ReflectiveOperationException var) {
            throw new OpenstackException(var);
        }
    }

    public static List<String> fieldNameForLambdaFunction(LambdaFunction ... fn) {
        LinkedList<String> fieldName = new LinkedList<String>();
        for (LambdaFunction lambdaFunction : fn) {
            fieldName.add(Reflections.fieldNameForLambdaFunction(lambdaFunction));
        }
        return fieldName;
    }
}

