/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.support;

import cn.xphsc.openstack.utils.Threads;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class ResourceWaiting {
    private ResourceWaiting() {
    }

    public static <T> T waitForResource(Supplier<T> resourceSupplier, int timeout, int intervalTime) {
        return ResourceWaiting.waitForResource(resourceSupplier, null, timeout, intervalTime);
    }

    public static <T> T waitForResource(Supplier<T> resourceSupplier, Predicate<T> waitCondition, int timeout, int intervalTime) {
        int waitSeconds = 0;
        T resource;
        while (!Objects.isNull(resource = resourceSupplier.get())) {
            if (Objects.nonNull(waitCondition) && waitCondition.test(resource)) {
                return resource;
            }
            if (timeout > 0 && waitSeconds > timeout) {
                return resource;
            }
            Threads.sleep(intervalTime);
            waitSeconds += intervalTime / 1000;
        }
        return null;
    }
}

