/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.utils.net;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;

public final class Cidr {
    private static final int DEFAULT_IP_START = 2;
    private static final int DEFAULT_IP_END = 253;
    private final IPAddress cidrAddress;
    private final int ipStart;
    private final int ipEnd;

    private Cidr(IPAddress cidr, int ipStart, int ipEnd) {
        this.cidrAddress = cidr;
        this.ipStart = ipStart;
        this.ipEnd = ipEnd;
    }

    public static Cidr of(IPAddress cidr) {
        return new Cidr(cidr, 2, 253);
    }

    public static Cidr of(String cidr) {
        return Cidr.of(cidr, 2, 253);
    }

    public static Cidr of(String cidr, int ipStart, int ipEnd) {
        IPAddressString cidrAddress = new IPAddressString(cidr);
        if (!cidrAddress.isValid()) {
            throw new IllegalArgumentException(String.format("illegal cidr %s", cidr));
        }
        return new Cidr(cidrAddress.getAddress().toZeroHost(), ipStart, ipEnd);
    }

    public IPAddress.IPVersion getIpVersion() {
        return this.cidrAddress.getIPVersion();
    }

    public IPAddressString getCidrAddress() {
        return this.cidrAddress.toAddressString();
    }

    public String getCidrString() {
        return this.cidrAddress.toNormalizedString();
    }

    public String getGateway() {
        return this.cidrAddress.getLower().withoutPrefixLength().increment(1L).toNormalizedString();
    }

    public String getAddress(int offset) {
        return this.cidrAddress.getLower().withoutPrefixLength().increment((long)offset).toNormalizedString();
    }

    public String getStartAddress() {
        return this.getAddress(this.ipStart);
    }

    public String getEndAddress() {
        return this.getAddress(this.ipEnd);
    }
}

