/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.utils.net;

import cn.xphsc.openstack.utils.net.Cidr;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;

public class Cidrs {
    public static final int IP_ALLOCATION_POOL_START = 129;
    public static final int IP_ALLOCATION_POOL_END = 253;
    public static final String DEFAULT_CIDR_IPV6 = "fe80:0:%x::/80";
    public static final String DEFAULT_CIDR_IPV4 = "10.10.%d.0/24";
    public static final int DEFAULT_NETWORK_PREFIX_LENGTH_IPV6 = 80;
    public static final int DEFAULT_NETWORK_PREFIX_LENGTH_IPV4 = 24;
    private final Cidr cidr;

    private Cidrs(Cidr cidr) {
        this.cidr = cidr;
    }

    public static Cidrs fromCidr(String cidr) {
        return new Cidrs(Cidr.of(cidr));
    }

    public static Cidrs fromCidr(Cidr cidr) {
        return new Cidrs(cidr);
    }

    public static Cidrs defaultCidr(IPAddress.IPVersion ipVersion, int subnetNo) {
        return IPAddress.IPVersion.IPV6.equals((Object)ipVersion) ? Cidrs.fromCidr(String.format(DEFAULT_CIDR_IPV6, subnetNo)) : Cidrs.fromCidr(String.format(DEFAULT_CIDR_IPV4, subnetNo));
    }

    public static Cidrs fromIp(String ip) {
        IPAddressString addressString = new IPAddressString(ip);
        if (!addressString.isValid()) {
            throw new IllegalArgumentException(String.format("illega ip %s", ip));
        }
        int prefixLen = addressString.isIPv6() ? 80 : 24;
        return new Cidrs(Cidr.of(addressString.getAddress().toPrefixBlock(prefixLen)));
    }

    public IPAddress.IPVersion getIpVersion() {
        return this.cidr.getIpVersion();
    }

    public IPAddressString getCidrAddress() {
        return this.cidr.getCidrAddress();
    }

    public String getCidrString() {
        return this.cidr.getCidrString();
    }

    public String getGateway() {
        return this.cidr.getAddress(1);
    }
}

