/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpResponse;

public class HttpResponseImpl
implements HttpResponse {
    private final Response response;

    private HttpResponseImpl(Response response) {
        this.response = response;
    }

    public static HttpResponseImpl wrap(Response response) {
        return new HttpResponseImpl(response);
    }

    public Response unwrap() {
        return this.response;
    }

    public <T> T getEntity(Class<T> returnType) {
        return this.getEntity(returnType, null);
    }

    public <T> T getEntity(Class<T> returnType, ExecutionOptions<T> options) {
        return (T)HttpEntityHandler.handle((HttpResponse)this, returnType, options, (boolean)Boolean.TRUE);
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public String getStatusMessage() {
        return this.response.getStatusInfo().getReasonPhrase();
    }

    public InputStream getInputStream() {
        this.response.bufferEntity();
        return (InputStream)this.response.readEntity(InputStream.class);
    }

    public String header(String name) {
        return (String)this.response.getStringHeaders().getFirst((Object)name);
    }

    public Map<String, String> headers() {
        HashMap<String, String> headers = new HashMap<String, String>();
        MultivaluedMap responseHeaders = this.response.getStringHeaders();
        for (String key : responseHeaders.keySet()) {
            headers.put(key, (String)responseHeaders.getFirst((Object)key));
        }
        return headers;
    }

    public <T> T readEntity(Class<T> typeToReadAs) {
        this.response.bufferEntity();
        return (T)this.response.readEntity(typeToReadAs);
    }

    public String getContentType() {
        return this.header("Content-Type");
    }

    public void close() throws IOException {
    }
}

