/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.boot.autoconfigure;

import cn.xphsc.openstack.core.entity.network.Network;
import cn.xphsc.openstack.core.entity.network.NetworkType;
import cn.xphsc.openstack.utils.net.Cidr;
import cn.xphsc.openstack.utils.net.Cidrs;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="openstack.cloud")
public class CloudClientExternalProperties {
    public static final String CLOUD_PREFIX = "cloud";
    private String externalNetVlanCidr;
    private String externalNetCidr;
    private String physicalNetwork;
    private String templatePath;

    public String getExternalNetVlanCidr() {
        return this.externalNetVlanCidr;
    }

    public void setExternalNetVlanCidr(String externalNetVlanCidr) {
        this.externalNetVlanCidr = externalNetVlanCidr;
    }

    public String getExternalNetCidr() {
        return this.externalNetCidr;
    }

    public void setExternalNetCidr(String externalNetCidr) {
        this.externalNetCidr = externalNetCidr;
    }

    public String getPhysicalNetwork() {
        return this.physicalNetwork;
    }

    public void setPhysicalNetwork(String physicalNetwork) {
        this.physicalNetwork = physicalNetwork;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public Cidrs getDefaultCidr(Network network) {
        return NetworkType.VLAN.equals(network.getNetworkType()) ? Cidrs.fromCidr(this.defaultCidrOfVlan(network.getId())) : Cidrs.fromCidr(this.externalNetCidr);
    }

    public Cidr defaultCidrOfVlan(int vlanId) {
        int ipSegment = vlanId % 256;
        return Cidr.of(String.format(this.externalNetVlanCidr, ipSegment), 129, 253);
    }

    public Cidr defaultCidrOfVlan(String vlanId) {
        int ipSegment = Integer.parseInt(vlanId) % 256;
        return Cidr.of(String.format(this.externalNetVlanCidr, ipSegment), 129, 253);
    }
}

