/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.boot.autoconfigure;

import cn.xphsc.openstack.boot.autoconfigure.OpenstackClientProperties;
import cn.xphsc.openstack.core.OpenstackTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="openstack", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={OpenstackClientProperties.class})
public class OpenstackClientAutoconfigure {
    private OpenstackClientProperties openstackClientProperties;

    public OpenstackClientAutoconfigure(OpenstackClientProperties openstackClientProperties) {
        this.openstackClientProperties = openstackClientProperties;
    }

    @Bean
    public OpenstackTemplate openstackTemplate() {
        OpenstackTemplate openstackTemplate = new OpenstackTemplate();
        openstackTemplate.setCloudUri(this.openstackClientProperties.getCloudUri());
        openstackTemplate.setUsername(this.openstackClientProperties.getUsername());
        openstackTemplate.setUserId(this.openstackClientProperties.getUserId());
        openstackTemplate.setPassword(this.openstackClientProperties.getPassword());
        openstackTemplate.setDomainName(this.openstackClientProperties.getDomainName());
        openstackTemplate.setProjectName(this.openstackClientProperties.getProjectName());
        openstackTemplate.setProjectId(this.openstackClientProperties.getProjectId());
        openstackTemplate.setToken(this.openstackClientProperties.getToken());
        openstackTemplate.setWaitTimeout(this.openstackClientProperties.getWaitTimeout());
        openstackTemplate.setIntervalTime(this.openstackClientProperties.getIntervalTime());
        openstackTemplate.setConnectionTimeout(this.openstackClientProperties.getConnectionTimeout());
        openstackTemplate.setReadTimeout(this.openstackClientProperties.getReadTimeout());
        return openstackTemplate;
    }
}

