/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client;

import cn.xphsc.openstack.core.client.APIProvider;
import cn.xphsc.openstack.core.client.container.AppcontainerQuotaService;
import cn.xphsc.openstack.core.client.container.AppcontainerService;
import cn.xphsc.openstack.core.client.network.VpnService;
import cn.xphsc.openstack.core.client.network.gateway.L2GatewayConnectionService;
import cn.xphsc.openstack.core.client.network.gateway.L2GatewayService;
import java.util.ServiceLoader;

public class Apis {
    private static final APIProvider provider = Apis.initializeProvider();

    public static <T> T get(Class<T> api) {
        return provider.get(api);
    }

    public static AppcontainerQuotaService appContainerQuotaService() {
        return Apis.get(AppcontainerQuotaService.class);
    }

    public static AppcontainerService appcontainerService() {
        return Apis.get(AppcontainerService.class);
    }

    public static L2GatewayService l2GatewayService() {
        return Apis.get(L2GatewayService.class);
    }

    public static L2GatewayConnectionService l2GatewayConnectionService() {
        return Apis.get(L2GatewayConnectionService.class);
    }

    public static VpnService vpnService() {
        return Apis.get(VpnService.class);
    }

    private static APIProvider initializeProvider() {
        APIProvider p = ServiceLoader.load(APIProvider.class, Apis.class.getClassLoader()).iterator().next();
        p.initialize();
        return p;
    }
}

