/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.compute.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.compute.FlavorService;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.utils.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.Flavor;
import org.springframework.stereotype.Component;

@Component
public class FlavorServiceImpl
implements FlavorService {
    private final OpenstackTemplate openstackTemplate;

    public FlavorServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public cn.xphsc.openstack.core.entity.compute.Flavor get(String flavorId) {
        Flavor flavor = this.openstackTemplate.compute().flavors().get(flavorId);
        return this.translateFlavor(flavor);
    }

    @Override
    public cn.xphsc.openstack.core.entity.compute.Flavor getByName(String name) {
        List<Flavor> flavors = this.flavorList();
        Optional<Flavor> optional = flavors.stream().filter(flavor -> Strings.equals(flavor.getName(), name)).findAny();
        return optional.map(this::translateFlavor).orElse(null);
    }

    @Override
    public List<cn.xphsc.openstack.core.entity.compute.Flavor> list() {
        return this.flavorList().stream().map(this::translateFlavor).collect(Collectors.toList());
    }

    @Override
    public Page<cn.xphsc.openstack.core.entity.compute.Flavor> list(PageQuery pageQuery) {
        List<Object> flavors = this.flavorList();
        if (Objects.isNull(pageQuery)) {
            return PageImpl.of(flavors, null, null);
        }
        if (Strings.isNotBlank(pageQuery.getName())) {
            flavors = flavors.stream().filter(flavor -> flavor.getName().contains(pageQuery.getName())).collect(Collectors.toList());
        }
        List cloudFlavors = flavors.stream().map(this::translateFlavor).collect(Collectors.toList());
        return PageImpl.of(cloudFlavors, pageQuery.getOffset(), pageQuery.getLimit());
    }

    @Override
    public cn.xphsc.openstack.core.entity.compute.Flavor create(cn.xphsc.openstack.core.entity.compute.Flavor flavor) {
        Flavor createdFlavor = this.createFlavor(flavor);
        Optional.ofNullable(createdFlavor).ifPresent(newFlavor -> this.setCdrom(newFlavor.getId(), flavor.getCdrom()));
        return this.translateFlavor(createdFlavor);
    }

    @Override
    public int delete(String flavorId) {
        ActionResponse actionResponse = this.openstackTemplate.compute().flavors().delete(flavorId);
        return actionResponse.isSuccess() ? 1 : 0;
    }

    private Flavor createFlavor(cn.xphsc.openstack.core.entity.compute.Flavor flavor) {
        return this.openstackTemplate.compute().flavors().create(flavor.getName(), flavor.getRam().intValue(), flavor.getVcpus().intValue(), flavor.getDisk().intValue(), flavor.getEphemeral().intValue(), flavor.getSwap().intValue(), (float)flavor.getRxtxFactor().intValue(), flavor.getPublic().booleanValue());
    }

    private List<Flavor> flavorList() {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("is_public", "None");
        return this.openstackTemplate.compute().flavors().list(true, filter);
    }

    private void setCdrom(String flavorId, String cdrom) {
        if (!Strings.equals("0", cdrom)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("cdrom", cdrom);
            this.openstackTemplate.compute().flavors().createAndUpdateExtraSpecs(flavorId, param);
        }
    }

    public cn.xphsc.openstack.core.entity.compute.Flavor translateFlavor(Flavor flavor) {
        if (Objects.isNull(flavor)) {
            return null;
        }
        cn.xphsc.openstack.core.entity.compute.Flavor cloudFlavor = cn.xphsc.openstack.core.entity.compute.Flavor.builder().name(flavor.getName()).ephemeral(flavor.getEphemeral()).isPublic(flavor.isPublic() != null ? flavor.isPublic() : false).ram(flavor.getRam()).disk(flavor.getDisk()).swap(flavor.getSwap()).vcpus(flavor.getVcpus()).rxtxFactor((int)flavor.getRxtxFactor()).build();
        cloudFlavor.setId(flavor.getId());
        return cloudFlavor;
    }
}

