/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.compute.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.compute.StackService;
import cn.xphsc.openstack.core.entity.compute.Stack;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.utils.Strings;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstack4j.model.common.ActionResponse;
import org.springframework.stereotype.Component;

@Component
public class StackServiceImpl
implements StackService {
    private final OpenstackTemplate openstackTemplate;

    public StackServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public Stack getByName(String stackName) {
        org.openstack4j.model.heat.Stack stack = this.openstackTemplate.heat().stacks().getStackByName(stackName);
        return this.translateStack(stack);
    }

    @Override
    public Page<Stack> list(PageQuery pageQuery) {
        List stacks = this.openstackTemplate.heat().stacks().list();
        List cloudStacks = stacks.stream().map(this::translateStack).collect(Collectors.toList());
        if (Objects.isNull(pageQuery)) {
            return PageImpl.of(cloudStacks, null, null);
        }
        if (Strings.isNotBlank(pageQuery.getName())) {
            cloudStacks = cloudStacks.stream().filter(stack -> Strings.equals(stack.getName(), pageQuery.getName())).collect(Collectors.toList());
        }
        return PageImpl.of(cloudStacks, pageQuery.getOffset(), pageQuery.getLimit());
    }

    @Override
    public int delete(String stackId, String stackName) {
        ActionResponse actionResponse = this.openstackTemplate.heat().stacks().delete(stackName, stackId);
        return actionResponse.isSuccess() ? 1 : 0;
    }

    private Stack translateStack(org.openstack4j.model.heat.Stack opsStack) {
        if (Objects.nonNull(opsStack)) {
            Stack stack = Stack.builder().name(opsStack.getName()).status(opsStack.getStatus()).createTime(opsStack.getCreationTime()).build();
            stack.setId(opsStack.getId());
            return stack;
        }
        return null;
    }
}

