/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.container.service;

import cn.xphsc.openstack.core.client.container.AppcontainerService;
import cn.xphsc.openstack.core.client.container.service.AppcontainerFileImpl;
import cn.xphsc.openstack.core.entity.container.AppContainerStatsInfo;
import cn.xphsc.openstack.core.entity.container.Appcontainer;
import cn.xphsc.openstack.core.entity.container.AppcontainerAction;
import cn.xphsc.openstack.core.entity.container.AppcontainerLog;
import cn.xphsc.openstack.core.entity.container.AppcontainerNetwork;
import cn.xphsc.openstack.core.entity.container.AppcontainerUpdate;
import cn.xphsc.openstack.core.entity.container.ContainerExecCmdResult;
import cn.xphsc.openstack.core.entity.container.ZunAppcontainer;
import cn.xphsc.openstack.utils.Strings;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.openstack.container.internal.BaseAppcontainerServices;

public class AppcontainerServiceImpl
extends BaseAppcontainerServices
implements AppcontainerService {
    @Override
    public Appcontainer get(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (Appcontainer)this.get(ZunAppcontainer.class, new String[]{this.uri("/containers/%s", new Object[]{containerId})}).execute();
    }

    @Override
    public Appcontainer create(Appcontainer appcontainer) {
        Preconditions.checkNotNull((Object)appcontainer);
        return (Appcontainer)this.post(ZunAppcontainer.class, new String[]{this.uri("/containers", new Object[0])}).header("OpenStack-API-Version", (Object)"container 1.39").entity((ModelEntity)appcontainer).execute();
    }

    @Override
    public ActionResponse delete(String containerId, boolean isForce) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.deleteWithResponse(new String[]{this.uri("/containers/%s", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").param("force", (Object)isForce).execute();
    }

    @Override
    public ActionResponse start(String containerId) {
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/start", new Object[]{containerId})}).execute();
    }

    @Override
    public ActionResponse stop(String containerId) {
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/stop", new Object[]{containerId})}).execute();
    }

    @Override
    public ActionResponse pause(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/pause", new Object[]{containerId})}).execute();
    }

    @Override
    public ActionResponse unPause(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/unpause", new Object[]{containerId})}).execute();
    }

    @Override
    public ActionResponse restart(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/reboot", new Object[]{containerId})}).execute();
    }

    @Override
    public ActionResponse rebuild(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/rebuild", new Object[]{containerId})}).execute();
    }

    @Override
    public List<? extends Appcontainer> list() {
        return ((ZunAppcontainer.Appcontainers)((Object)this.get(ZunAppcontainer.Appcontainers.class, new String[]{this.uri("/containers", new Object[0])}).execute())).getList();
    }

    @Override
    public List<? extends Appcontainer> list(Map<String, String> filteringParams) {
        return ((ZunAppcontainer.Appcontainers)((Object)this.get(ZunAppcontainer.Appcontainers.class, new String[]{this.uri("/containers", new Object[0])}).params(filteringParams).execute())).getList();
    }

    @Override
    public Appcontainer update(AppcontainerUpdate appcontainerUpdate) {
        Objects.requireNonNull(appcontainerUpdate.getContainerId());
        Objects.requireNonNull(appcontainerUpdate);
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        if (Strings.isNotBlank(appcontainerUpdate.getName())) {
            params.put("name", appcontainerUpdate.getName());
        }
        if (appcontainerUpdate.getCpu() != null) {
            params.put("cpu", appcontainerUpdate.getCpu());
        }
        if (appcontainerUpdate.getMemory() != null) {
            params.put("memory", appcontainerUpdate.getMemory());
        }
        return (Appcontainer)this.patch(ZunAppcontainer.class, new String[]{this.uri("containers/%s", new Object[]{appcontainerUpdate.getContainerId()})}).contentType("application/json-patch+json").params(params).execute();
    }

    @Override
    public List<AppcontainerNetwork> networkList(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return ((AppcontainerNetwork.AppcontainerNetworks)((Object)this.get(AppcontainerNetwork.AppcontainerNetworks.class, new String[]{this.uri("/containers/%s/network_list", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").execute())).getList();
    }

    @Override
    public AppContainerStatsInfo stats(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (AppContainerStatsInfo)this.get(AppContainerStatsInfo.class, new String[]{this.uri("/containers/%s/stats", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").execute();
    }

    @Override
    public ActionResponse kill(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/kill", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").execute();
    }

    @Override
    public String logs(AppcontainerLog appcontainerLog) {
        Preconditions.checkNotNull((Object)appcontainerLog.getContainerId());
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        if (appcontainerLog.getStderr() != null) {
            params.put("stderr", appcontainerLog.getStderr());
        }
        if (appcontainerLog.getStdout() != null) {
            params.put("stdout", appcontainerLog.getStdout());
        }
        if (Strings.isNotBlank(appcontainerLog.getSince())) {
            params.put("since", appcontainerLog.getSince());
        }
        if (Strings.isNotBlank(appcontainerLog.getTail())) {
            params.put("tail", appcontainerLog.getTail());
        }
        JsonNode jsonNode = (JsonNode)this.get(JsonNode.class, new String[]{this.uri("/containers/%s/logs", new Object[]{appcontainerLog.getContainerId()})}).contentType("application/json-patch+json").params(params).execute();
        return jsonNode.asText();
    }

    @Override
    public List<AppcontainerAction> listActions(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return ((AppcontainerAction.AppcontainerActions)((Object)this.get(AppcontainerAction.AppcontainerActions.class, new String[]{this.uri("/containers/%s/container_actions", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").execute())).getList();
    }

    @Override
    public AppcontainerAction actions(String containerId, String requestId) {
        Preconditions.checkNotNull((Object)containerId);
        return (AppcontainerAction)this.get(AppcontainerAction.class, new String[]{this.uri("/containers/%s/container_actions/%s", new Object[]{containerId, requestId})}).header("OpenStack-API-Version", (Object)"container 1.39").execute();
    }

    @Override
    public ActionResponse writeFile(String containerId, String containerPath, String fileName, String fileContent) {
        Preconditions.checkNotNull((Object)containerId);
        Preconditions.checkNotNull((Object)containerPath);
        Preconditions.checkNotNull((Object)fileName);
        Preconditions.checkNotNull((Object)fileContent);
        String base64DataJson = null;
        try {
            base64DataJson = AppcontainerFileImpl.getTarFileBase64Json(fileName, fileContent, false);
        }
        catch (IOException var8) {
            var8.printStackTrace();
        }
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/put_archive", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").param("path", (Object)containerPath).json(base64DataJson).execute();
    }

    @Override
    public ActionResponse writeFile(String containerId, String containerPath, String fileName, String fileContent, Boolean isBase64) {
        Preconditions.checkNotNull((Object)containerId);
        Preconditions.checkNotNull((Object)containerPath);
        Preconditions.checkNotNull((Object)fileName);
        Preconditions.checkNotNull((Object)fileContent);
        Preconditions.checkNotNull((Object)isBase64);
        String base64DataJson = null;
        try {
            base64DataJson = AppcontainerFileImpl.getTarFileBase64Json(fileName, fileContent, isBase64);
        }
        catch (IOException var8) {
            var8.printStackTrace();
        }
        return (ActionResponse)this.post(ActionResponse.class, new String[]{this.uri("/containers/%s/put_archive", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").param("path", (Object)containerPath).json(base64DataJson).execute();
    }

    @Override
    public String readFile(String containerId, String containerPath) {
        Preconditions.checkNotNull((Object)containerId);
        Preconditions.checkNotNull((Object)containerPath);
        Map result = (Map)this.get(Map.class, new String[]{this.uri("/containers/%s/get_archive", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").param("path", (Object)containerPath).execute();
        String fileContent = null;
        try {
            fileContent = AppcontainerFileImpl.getFileContent((String)result.get("data"));
        }
        catch (IOException var6) {
            var6.printStackTrace();
        }
        return fileContent;
    }

    @Override
    public ContainerExecCmdResult executeCommand(String containerId, String command) {
        Preconditions.checkNotNull((Object)containerId);
        Preconditions.checkNotNull((Object)command);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", command);
        params.put("run", true);
        ContainerExecCmdResult result = (ContainerExecCmdResult)this.post(ContainerExecCmdResult.class, new String[]{this.uri("/containers/%s/execute", new Object[]{containerId})}).header("OpenStack-API-Version", (Object)"container 1.39").params(params).execute();
        return Objects.isNull(result) ? new ContainerExecCmdResult("Not Found", 404) : result;
    }
}

