/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.container.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.container.AppcontainerService;
import cn.xphsc.openstack.core.client.container.ContainerService;
import cn.xphsc.openstack.core.client.network.FloatingIpService;
import cn.xphsc.openstack.core.entity.container.Action;
import cn.xphsc.openstack.core.entity.container.ActionEvent;
import cn.xphsc.openstack.core.entity.container.AppContainerAddress;
import cn.xphsc.openstack.core.entity.container.AppContainerStatsInfo;
import cn.xphsc.openstack.core.entity.container.Appcontainer;
import cn.xphsc.openstack.core.entity.container.AppcontainerAction;
import cn.xphsc.openstack.core.entity.container.AppcontainerLog;
import cn.xphsc.openstack.core.entity.container.AppcontainerNetwork;
import cn.xphsc.openstack.core.entity.container.AppcontainerUpdate;
import cn.xphsc.openstack.core.entity.container.Container;
import cn.xphsc.openstack.core.entity.container.ContainerAction;
import cn.xphsc.openstack.core.entity.container.ContainerCommit;
import cn.xphsc.openstack.core.entity.container.ContainerExecCmdResult;
import cn.xphsc.openstack.core.entity.container.ContainerNetworkAttach;
import cn.xphsc.openstack.core.entity.container.ContainerNetworkDetach;
import cn.xphsc.openstack.core.entity.container.ContainerWriteFile;
import cn.xphsc.openstack.core.entity.container.DockerStatus;
import cn.xphsc.openstack.core.entity.container.Status;
import cn.xphsc.openstack.core.entity.container.ZunAppcontainer;
import cn.xphsc.openstack.core.entity.network.FloatingIp;
import cn.xphsc.openstack.core.exception.OpenstackException;
import cn.xphsc.openstack.core.executor.NativeExternalApiExecutor;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.ContainerBody;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.core.support.ResourceWaiting;
import cn.xphsc.openstack.utils.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.container.AppContainer;
import org.openstack4j.model.container.AppContainerCommit;
import org.openstack4j.model.container.AppContainerCreate;
import org.openstack4j.model.container.NetworkAttach;
import org.openstack4j.model.container.NetworkDetach;
import org.openstack4j.model.container.builder.AppContainerCreateBuilder;
import org.openstack4j.openstack.container.domain.ZunAppContainerCommit;
import org.openstack4j.openstack.container.domain.ZunAppContainerCreate;
import org.openstack4j.openstack.container.domain.ZunNetworkAttach;
import org.openstack4j.openstack.container.domain.ZunNetworkDetach;
import org.springframework.stereotype.Component;

@Component
public class ContainerServiceImpl
implements ContainerService {
    private final OpenstackTemplate openstackTemplate;
    private final FloatingIpService floatingIpService;

    public ContainerServiceImpl(OpenstackTemplate openstackTemplate, FloatingIpService floatingIpService) {
        this.openstackTemplate = openstackTemplate;
        this.floatingIpService = floatingIpService;
    }

    @Override
    public List<Container> list() {
        List<? extends Appcontainer> list = this.getAppcontainerService().list();
        ArrayList<Container> containers = new ArrayList<Container>(list.size());
        for (Appcontainer appcontainer : list) {
            Container container = this.translateContainer(appcontainer);
            containers.add(container);
        }
        return containers;
    }

    @Override
    public Page<Container> list(PageQuery pageQuery) {
        List<Appcontainer> list = this.getAppcontainerService().list();
        list = list.stream().filter(appcontainer -> Strings.isEmpty(pageQuery.getName()) || appcontainer.getName().contains(pageQuery.getName())).filter(appcontainer -> Strings.isEmpty(pageQuery.getStatus()) || appcontainer.getStatus().name().contains(pageQuery.getStatus())).collect(Collectors.toList());
        ArrayList<Container> containers = new ArrayList<Container>(list.size());
        for (Appcontainer appcontainer2 : list) {
            Container container = this.translateContainer(appcontainer2);
            containers.add(container);
        }
        return PageImpl.of(containers, pageQuery.getOffset(), pageQuery.getLimit());
    }

    @Override
    public Container get(String containerId) {
        Appcontainer appcontainer = this.getAppcontainerService().get(containerId);
        return this.translateContainer(appcontainer);
    }

    @Override
    public Container create(ContainerBody containerBody) {
        AppContainer appContainer;
        AppcontainerService appcontainerService = this.getAppcontainerService();
        try {
            appContainer = this.openstackTemplate.appcontainer().create(this.getAppContainerCreateBuilder(containerBody));
        }
        catch (ClientResponseException exception) {
            throw new OpenstackException(exception.getMessage(), exception);
        }
        Appcontainer result = ResourceWaiting.waitForResource(() -> appcontainerService.get(appContainer.getId()), item -> !Status.CREATED.equals((Object)item.getStatus()), this.openstackTemplate.getWaitTimeout(), this.openstackTemplate.getIntervalTime());
        return this.translateContainer(result);
    }

    @Override
    public Container update(AppcontainerUpdate appcontainerUpdate) {
        AppcontainerService appcontainerService = this.getAppcontainerService();
        Appcontainer result = appcontainerService.update(appcontainerUpdate);
        return this.translateContainer(result);
    }

    @Override
    public Container createAndBindIp(ContainerBody containerBody) {
        Container container = null;
        Container appContainer = this.create(containerBody);
        if (Boolean.TRUE.equals(containerBody.getExternal())) {
            FloatingIp floatingIp = this.floatingIpService.create(containerBody.getNetworkId(), containerBody.getPortId(), containerBody.getFloatingIp());
            container = Container.builder().id(appContainer.getId()).status(appContainer.getStatus()).statusDetail(appContainer.getStatusDetail()).name(appContainer.getName()).image(appContainer.getImage()).imageDriver(appContainer.getImageDriver()).privileged(appContainer.getPrivileged()).nets(appContainer.getNets()).floatIp(appContainer.getFloatIp()).securityGroups(appContainer.getSecurityGroups()).ports(appContainer.getPorts()).address(appContainer.getAddress()).floatIp(floatingIp).build();
        }
        return container;
    }

    @Override
    public void delete(String containerId, boolean isForce) {
        ActionResponse response = this.getAppcontainerService().delete(containerId, isForce);
        if (!response.isSuccess() && response.getCode() != 404) {
            throw new OpenstackException(response.getFault());
        }
    }

    @Override
    public List<AppcontainerNetwork> networkList(String containerId) {
        return this.getAppcontainerService().networkList(containerId);
    }

    @Override
    public void start(String containerId) {
        AppcontainerService appcontainerService = this.getAppcontainerService();
        ActionResponse response = appcontainerService.start(containerId);
        if (!response.isSuccess()) {
            throw new OpenstackException(response.getFault());
        }
        this.waitForContainer(containerId, appcontainerService, Status.RUNNING);
    }

    @Override
    public ActionResponse action(String containerId, Action action) {
        ActionResponse response = null;
        AppcontainerService appcontainerService = this.getAppcontainerService();
        switch (action) {
            case STOP: {
                response = appcontainerService.stop(containerId);
                break;
            }
            case START: {
                response = appcontainerService.start(containerId);
                break;
            }
            case PAUSE: {
                response = appcontainerService.pause(containerId);
                break;
            }
            case UNPAUSE: {
                response = appcontainerService.unPause(containerId);
                break;
            }
            case KILL: {
                response = appcontainerService.kill(containerId);
                break;
            }
            case RESTART: {
                response = appcontainerService.restart(containerId);
                break;
            }
        }
        return response;
    }

    @Override
    public void stop(String containerId) {
        AppcontainerService appcontainerService = this.getAppcontainerService();
        ActionResponse response = appcontainerService.stop(containerId);
        if (!response.isSuccess()) {
            throw new OpenstackException(response.getFault());
        }
        this.waitForContainer(containerId, appcontainerService, Status.STOPPED);
    }

    @Override
    public void rebuild(String containerId) {
        AppcontainerService appcontainerService = this.getAppcontainerService();
        ActionResponse response = appcontainerService.rebuild(containerId);
        if (!response.isSuccess()) {
            throw new OpenstackException(response.getFault());
        }
        this.waitForContainer(containerId, appcontainerService, Status.RUNNING);
    }

    @Override
    public void pause(String containerId) {
        ActionResponse response = this.getAppcontainerService().pause(containerId);
        if (!response.isSuccess()) {
            throw new OpenstackException(response.getFault());
        }
    }

    @Override
    public void unPause(String containerId) {
        ActionResponse response = this.getAppcontainerService().unPause(containerId);
        if (!response.isSuccess()) {
            throw new OpenstackException(response.getFault());
        }
    }

    @Override
    public void restart(String containerId) {
        AppcontainerService appcontainerService = this.getAppcontainerService();
        ActionResponse response = appcontainerService.restart(containerId);
        if (!response.isSuccess()) {
            throw new OpenstackException(response.getFault());
        }
        this.waitForContainer(containerId, appcontainerService, Status.RUNNING);
    }

    @Override
    public AppContainerStatsInfo stats(String containerId) {
        return this.getAppcontainerService().stats(containerId);
    }

    @Override
    public ActionResponse kill(String containerId) {
        return this.getAppcontainerService().kill(containerId);
    }

    @Override
    public String logs(AppcontainerLog appcontainerLog) {
        return this.getAppcontainerService().logs(appcontainerLog);
    }

    @Override
    public List<ContainerAction> listActions(String containerId) {
        List<AppcontainerAction> appcontainerActions = this.getAppcontainerService().listActions(containerId);
        ArrayList containerActionList = Lists.newArrayList();
        for (AppcontainerAction appcontainerAction : appcontainerActions) {
            ContainerAction containerAction = ContainerAction.builder().action(appcontainerAction.getAction()).containerId(appcontainerAction.getContainerId()).message(appcontainerAction.getMessage()).projectId(appcontainerAction.getProjectId()).finishTime(appcontainerAction.getStartTime()).finishTime(appcontainerAction.getFinishTime()).userId(appcontainerAction.getUserId()).build();
            containerActionList.add(containerAction);
        }
        return containerActionList;
    }

    @Override
    public ContainerAction actions(String containerId, String requestId) {
        AppcontainerAction appcontainerAction = this.getAppcontainerService().actions(containerId, requestId);
        ArrayList events = Lists.newArrayList();
        List<AppcontainerAction.AppEvents> appEvents = appcontainerAction.getEvents();
        for (AppcontainerAction.AppEvents appEvent : appEvents) {
            ActionEvent event = ActionEvent.builder().event(appEvent.event).startTime(appEvent.startTime).result(appEvent.result).finishTime(appEvent.finishTime).traceback(appEvent.traceback != null ? appEvent.traceback : null).build();
            events.add(event);
        }
        ContainerAction containerAction = ContainerAction.builder().action(appcontainerAction.getAction()).containerId(appcontainerAction.getContainerId()).message(appcontainerAction.getMessage()).projectId(appcontainerAction.getProjectId()).startTime(appcontainerAction.getStartTime()).finishTime(appcontainerAction.getFinishTime()).userId(appcontainerAction.getUserId()).events(events).build();
        return containerAction;
    }

    @Override
    public ActionResponse writeFile(String containerId, String containerPath, String fileName, String fileContent) {
        ActionResponse actionResponse = this.getAppcontainerService().writeFile(containerId, containerPath, fileName, fileContent);
        return actionResponse;
    }

    @Override
    public ActionResponse writeFile(ContainerWriteFile containerWriteFile) {
        ActionResponse actionResponse = null;
        actionResponse = containerWriteFile.getBase64() == null ? this.writeFile(containerWriteFile.getContainerId(), containerWriteFile.getContainerPath(), containerWriteFile.getFileName(), containerWriteFile.getFileContent()) : this.writeFile(containerWriteFile.getContainerId(), containerWriteFile.getContainerPath(), containerWriteFile.getFileName(), containerWriteFile.getFileContent(), containerWriteFile.getBase64());
        return actionResponse;
    }

    @Override
    public ActionResponse writeFile(String containerId, String containerPath, String fileName, String fileContent, Boolean isBase64) {
        return this.getAppcontainerService().writeFile(containerId, containerPath, fileName, fileContent, isBase64);
    }

    @Override
    public String readFile(String containerId, String containerPath) {
        return this.getAppcontainerService().readFile(containerId, containerPath);
    }

    @Override
    public ContainerExecCmdResult executeCommand(String containerId, String command) {
        return this.getAppcontainerService().executeCommand(containerId, command);
    }

    @Override
    public String attach(String containerId) {
        return this.openstackTemplate.appcontainer().attach(containerId);
    }

    @Override
    public String commit(ContainerCommit containerCommit) {
        AppContainerCommit appContainerCommit = (AppContainerCommit)ZunAppContainerCommit.builder().containerId(containerCommit.getContainerId()).repository(containerCommit.getRepository()).tag(containerCommit.getTag()).build();
        return this.openstackTemplate.appcontainer().commit(appContainerCommit);
    }

    @Override
    public ActionResponse networkAttach(ContainerNetworkAttach containerNetworkAttach) {
        NetworkAttach networkAttach = (NetworkAttach)ZunNetworkAttach.builder().network(containerNetworkAttach.getNetwork()).port(containerNetworkAttach.getPort()).fixedIp(containerNetworkAttach.getFixedIp()).build();
        return this.openstackTemplate.appcontainer().networkAttach(containerNetworkAttach.getContainerId(), networkAttach);
    }

    @Override
    public ActionResponse networkDetach(ContainerNetworkDetach containerNetworkDetach) {
        NetworkDetach networkDetach = (NetworkDetach)ZunNetworkDetach.builder().network(containerNetworkDetach.getNetwork()).port(containerNetworkDetach.getPort()).build();
        return this.openstackTemplate.appcontainer().networkDetach(containerNetworkDetach.getContainerId(), networkDetach);
    }

    public AppcontainerService getAppcontainerService() {
        NativeExternalApiExecutor executor = new NativeExternalApiExecutor(this.openstackTemplate::initOpenstackClient, NativeExternalApiExecutor.NativeMode.APPCUSTOMCONTAINER);
        AppcontainerService result = (AppcontainerService)executor.execute();
        return result;
    }

    private AppContainerCreate getAppContainerCreateBuilder(ContainerBody containerBody) {
        AppContainerCreateBuilder appcontainerBuilder = ZunAppContainerCreate.builder();
        String imageDriver = null;
        if (containerBody.getImageDriver() != null) {
            imageDriver = containerBody.getImageDriver().name();
        }
        appcontainerBuilder.imageDriver(AppContainerCreate.ImageDriver.valueOf(imageDriver));
        appcontainerBuilder.name(containerBody.getName());
        appcontainerBuilder.image(containerBody.getImage());
        if (containerBody.getPortId() != null) {
            appcontainerBuilder.addNetPort(containerBody.getPortId());
        }
        if (containerBody.getNetworkId() != null) {
            appcontainerBuilder.addNet(containerBody.getNetworkId());
        }
        if (containerBody.getPrivileged() != null) {
            appcontainerBuilder.privileged(containerBody.getPrivileged());
        }
        if (containerBody.getSecurityGroups() != null) {
            appcontainerBuilder.securityGroups(containerBody.getSecurityGroups());
        }
        if (containerBody.getCmd() != null) {
            appcontainerBuilder.command(containerBody.getCmd());
        }
        if (containerBody.getCpu() != null) {
            appcontainerBuilder.cpu(containerBody.getCpu());
        }
        if (containerBody.getMemory() != null) {
            appcontainerBuilder.memory(containerBody.getMemory());
        }
        if (Strings.isNotBlank(containerBody.getRestartPolicy())) {
            appcontainerBuilder.restartPolicy(containerBody.getRestartPolicy(), 0);
        }
        appcontainerBuilder.interactive(true);
        return (AppContainerCreate)appcontainerBuilder.build();
    }

    private Container translateContainer(Appcontainer appcontainer) {
        Map<String, List<ZunAppcontainer.AppSubnet>> addresses;
        Collection<List<ZunAppcontainer.AppSubnet>> appSubnets;
        if (Objects.isNull(appcontainer)) {
            return null;
        }
        ArrayList<AppContainerAddress> appContainerAddressList = new ArrayList<AppContainerAddress>();
        if (appcontainer.getAddresses() != null && (appSubnets = (addresses = appcontainer.getAddresses()).values()) != null) {
            for (List<ZunAppcontainer.AppSubnet> appSubnet : appSubnets) {
                for (ZunAppcontainer.AppSubnet app : appSubnet) {
                    AppContainerAddress address = AppContainerAddress.builder().addr(app.addr).port(app.port).build();
                    appContainerAddressList.add(address);
                }
            }
        }
        Container container = Container.builder().id(appcontainer.getId()).name(appcontainer.getName()).image(appcontainer.getImage()).imageDriver(appcontainer.getImageDriver()).securityGroups(appcontainer.getSecurityGroups()).ports(appcontainer.getPorts()).statusDetail(appcontainer.getStatusDetail()).privileged(appcontainer.isPrivileged()).cmd(appcontainer.getCmd()).imagePullPolicy(appcontainer.getImagePullPolicy()).cpu(appcontainer.getCpu()).memory(appcontainer.getMemory()).address(appContainerAddressList).status(DockerStatus.valueOf(appcontainer.getStatus().name())).build();
        return container;
    }

    private void waitForContainer(String containerId, AppcontainerService appcontainerService, Status status) {
        ResourceWaiting.waitForResource(() -> appcontainerService.get(containerId), item -> status.equals((Object)item.getStatus()), this.openstackTemplate.getWaitTimeout(), this.openstackTemplate.getIntervalTime());
    }
}

