/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.heat.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.heat.EventsService;
import cn.xphsc.openstack.core.entity.heat.Event;
import cn.xphsc.openstack.core.query.EventQuery;
import cn.xphsc.openstack.utils.Strings;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openstack4j.model.heat.Event;
import org.springframework.stereotype.Component;

@Component
public class EventsServiceImpl
implements EventsService {
    private final OpenstackTemplate openstackTemplate;

    @Override
    public List<cn.xphsc.openstack.core.entity.heat.Event> list(EventQuery eventQuery) {
        return this.translateEvent(eventQuery);
    }

    public EventsServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public cn.xphsc.openstack.core.entity.heat.Event show(EventQuery eventQuery) {
        return this.translateEventForEntity(eventQuery);
    }

    private List<cn.xphsc.openstack.core.entity.heat.Event> translateEvent(EventQuery eventQuery) {
        Collection events = null;
        if (Strings.isBlank(eventQuery.getResourceName()) && Strings.isBlank(eventQuery.getEventId()) && Strings.isNotBlank(eventQuery.getStackId())) {
            events = this.openstackTemplate.heat().events().list(eventQuery.getStackName(), eventQuery.getStackId());
        }
        if (Strings.isBlank(eventQuery.getEventId()) && Strings.isNotBlank(eventQuery.getStackId()) && Strings.isNotBlank(eventQuery.getResourceName())) {
            events = this.openstackTemplate.heat().events().list(eventQuery.getStackName(), eventQuery.getStackId(), eventQuery.getResourceName());
        }
        List<cn.xphsc.openstack.core.entity.heat.Event> eventList = events.stream().map(evt -> {
            Event.Builder event = cn.xphsc.openstack.core.entity.heat.Event.builder();
            event.build().setId(evt.getId());
            event.localReourceId(evt.getLocalReourceId());
            event.resourceName(evt.getResourceName());
            event.resourceStatus(evt.getResourceStatus());
            event.physicalResourceId(evt.getPhysicalResourceId());
            event.resourceType(evt.getResourceType());
            event.time(evt.getTime());
            return event.build();
        }).collect(Collectors.toList());
        return eventList;
    }

    private cn.xphsc.openstack.core.entity.heat.Event translateEventForEntity(EventQuery eventQuery) {
        Event heatEvent = this.openstackTemplate.heat().events().show(eventQuery.getStackName(), eventQuery.getStackId(), eventQuery.getResourceName(), eventQuery.getEventId());
        Event.Builder builder = cn.xphsc.openstack.core.entity.heat.Event.builder();
        builder.localReourceId(heatEvent.getLocalReourceId());
        builder.resourceName(heatEvent.getResourceName());
        builder.resourceStatus(heatEvent.getResourceStatus());
        builder.physicalResourceId(heatEvent.getPhysicalResourceId());
        builder.resourceType(heatEvent.getResourceType());
        builder.time(heatEvent.getTime());
        cn.xphsc.openstack.core.entity.heat.Event event = builder.build();
        event.setId(heatEvent.getId());
        return event;
    }
}

