/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.network.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.exception.OpenstackException;
import cn.xphsc.openstack.utils.Strings;
import cn.xphsc.openstack.utils.net.Cidr;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openstack4j.api.Builders;
import org.openstack4j.api.exceptions.OS4JException;
import org.openstack4j.api.networking.NetworkService;
import org.openstack4j.model.network.IPVersionType;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.NetworkType;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.model.network.builder.SubnetBuilder;
import org.springframework.stereotype.Component;

@Component
public class NetworkExternalService {
    private final OpenstackTemplate openstackTemplate;

    public NetworkExternalService(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    public Network findVlanNetwork(int vlanId, Cidr cidr, String physicalNetwork1, String start, String end, boolean dhcp) {
        Optional<? extends Network> network = this.getVlanNetwork(vlanId, physicalNetwork1);
        if (network != null) {
            return network.get();
        }
        return this.createVlanNetwork(vlanId, cidr, physicalNetwork1, start, end, dhcp);
    }

    public Optional<? extends Network> getVlanNetwork(int vlanId, String physicalNetworkParam) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("provider:network_type", "vlan");
        params.put("provider:segmentation_id", String.valueOf(vlanId));
        params.put("router:external", Boolean.TRUE.toString());
        params.put("provider:physical_network", physicalNetworkParam);
        return this.getNetwork(params);
    }

    public Network createVlanNetwork(int vlanId, Cidr cidr, String physicalNetwork1, String start, String end, boolean dhcp) {
        try {
            NetworkService networkService = this.openstackTemplate.network();
            Network network = networkService.create((Network)Builders.network().name(this.vlanNetName(physicalNetwork1, vlanId)).networkType(NetworkType.VLAN).segmentId(String.valueOf(vlanId)).physicalNetwork(physicalNetwork1).isRouterExternal(true).adminStateUp(true).build());
            SubnetBuilder subnetBuilder = Builders.subnet().name(this.subnetName(vlanId)).cidr(cidr.getCidrString()).gateway(cidr.getGateway()).ipVersion(IPVersionType.V4).network(network).enableDHCP(dhcp);
            if (Strings.isNotEmpty(start) && Strings.isNotEmpty(end)) {
                subnetBuilder.addPool(start, end);
            }
            this.openstackTemplate.subnet().create((Subnet)subnetBuilder.build());
            return network;
        }
        catch (OS4JException var10) {
            throw new OpenstackException(String.format("create network for VLan %d failed", vlanId), var10);
        }
    }

    private Optional<? extends Network> getNetwork(Map<String, String> params) {
        return this.openstackTemplate.network().list(params).stream().findFirst();
    }

    private String subnetName(int vlanId) {
        return String.format("subnet-vlan-%d", vlanId);
    }

    private String vlanNetName(String physicalNetwork1, int vlanId) {
        return String.format("external-net-vlan-%s-%d", physicalNetwork1, vlanId);
    }
}

