/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.network.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.network.RouterService;
import cn.xphsc.openstack.core.entity.network.Router;
import cn.xphsc.openstack.core.exception.OpenstackException;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openstack4j.api.Builders;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.AttachInterfaceType;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.Port;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.model.network.builder.RouterBuilder;
import org.springframework.stereotype.Component;

@Component
public class RouterServiceImpl
implements RouterService {
    private final OpenstackTemplate openstackTemplate;

    public RouterServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public Router get(String routerId) {
        return this.translateRouter(this.openstackTemplate.networking().router().get(routerId));
    }

    @Override
    public List<Router> list() {
        return this.listByName(null);
    }

    @Override
    public Page<Router> list(PageQuery pageQuery) {
        List<Router> routerList = this.listByName(pageQuery.getName());
        return PageImpl.of(routerList, pageQuery.getOffset(), pageQuery.getLimit());
    }

    @Override
    public Router create(Router router) {
        try {
            org.openstack4j.model.network.Router opsRouter = this.openstackTemplate.networking().router().create((org.openstack4j.model.network.Router)Builders.router().name(router.getName()).adminStateUp(router.getAdminStateUp().booleanValue()).externalGateway(router.getExternalNetworkId()).build());
            return this.translateRouter(opsRouter);
        }
        catch (ClientResponseException var3) {
            throw new OpenstackException(var3.getMessage());
        }
    }

    @Override
    public Router update(Router router) {
        try {
            org.openstack4j.model.network.Router opsRouter = this.openstackTemplate.networking().router().get(router.getId());
            opsRouter = this.openstackTemplate.networking().router().update((org.openstack4j.model.network.Router)((RouterBuilder)opsRouter.toBuilder()).adminStateUp(router.getAdminStateUp().booleanValue()).name(router.getName()).build());
            return this.translateRouter(opsRouter);
        }
        catch (ClientResponseException exception) {
            throw new OpenstackException(exception.getMessage());
        }
    }

    @Override
    public int delete(String routerId) {
        ActionResponse actionResponse = this.openstackTemplate.networking().router().delete(routerId);
        return actionResponse.isSuccess() ? 1 : 0;
    }

    @Override
    public int batchDelete(List<String> routerIds) {
        for (String id : routerIds) {
            this.openstackTemplate.networking().router().delete(id);
        }
        return 1;
    }

    @Override
    public int removeGateway(String routerId) {
        try {
            org.openstack4j.model.network.Router router = this.openstackTemplate.networking().router().get(routerId);
            this.openstackTemplate.networking().router().update((org.openstack4j.model.network.Router)((RouterBuilder)router.toBuilder()).clearExternalGateway().build());
        }
        catch (ClientResponseException var4) {
            return 0;
        }
        return 1;
    }

    @Override
    public int updateRouterGateway(String routerId, String networkId) {
        try {
            org.openstack4j.model.network.Router router = this.openstackTemplate.networking().router().get(routerId);
            this.openstackTemplate.networking().router().update((org.openstack4j.model.network.Router)((RouterBuilder)router.toBuilder()).externalGateway(networkId).build());
        }
        catch (ClientResponseException var5) {
            return 0;
        }
        return 1;
    }

    @Override
    public int addRouterInterface(String routerId, String subnetId, String fixedIp) {
        try {
            Subnet subnet = this.openstackTemplate.networking().subnet().get(subnetId);
            if (Strings.isEmpty(fixedIp)) {
                RouterInterface routerInterface = this.openstackTemplate.networking().router().attachInterface(routerId, AttachInterfaceType.SUBNET, subnetId);
                if (Objects.isNull(routerInterface)) {
                    return 0;
                }
            } else {
                Port port = this.openstackTemplate.networking().port().create((Port)Builders.port().networkId(subnet.getNetworkId()).fixedIp(fixedIp, subnetId).build());
                RouterInterface routerInterface = this.openstackTemplate.networking().router().attachInterface(routerId, AttachInterfaceType.PORT, port.getId());
                if (Objects.isNull(routerInterface)) {
                    return 0;
                }
            }
        }
        catch (ClientResponseException var7) {
            return 0;
        }
        return 1;
    }

    @Override
    public int removeRouteInterface(String routeInterfaceId) {
        try {
            Port port = this.openstackTemplate.networking().port().get(routeInterfaceId);
            this.openstackTemplate.networking().router().detachInterface(port.getDeviceId(), (String)null, port.getId());
        }
        catch (ClientResponseException var4) {
            return 0;
        }
        return 1;
    }

    private Router translateRouter(org.openstack4j.model.network.Router opsRouter) {
        if (Objects.isNull(opsRouter)) {
            return null;
        }
        Router.Builder builder = Router.builder();
        builder.name(opsRouter.getName());
        builder.isAdminStateUp(opsRouter.isAdminStateUp());
        builder.status(opsRouter.getStatus().toString());
        if (opsRouter.getExternalGatewayInfo() != null) {
            String networkId = opsRouter.getExternalGatewayInfo().getNetworkId();
            Network net = this.openstackTemplate.networking().network().get(networkId);
            builder.availabilityZones(net.getAvailabilityZones());
            builder.externalNetwork(net.getName());
            builder.externalNetworkId(networkId);
        }
        Router router = builder.build();
        router.setId(opsRouter.getId());
        return router;
    }

    private List<Router> listByName(String name) {
        HashMap<String, Network> networkInfo = new HashMap<String, Network>();
        List routers = this.openstackTemplate.networking().router().list();
        ArrayList<Router> routerList = new ArrayList<Router>();
        Iterator iterator = routers.iterator();
        while (iterator.hasNext()) {
            org.openstack4j.model.network.Router opsRouter = (org.openstack4j.model.network.Router)iterator.next();
            if (!Strings.isEmpty(name) && !opsRouter.getName().contains(name)) continue;
            Router.Builder builder = Router.builder();
            builder.name(opsRouter.getName());
            builder.isAdminStateUp(opsRouter.isAdminStateUp());
            builder.status(opsRouter.getStatus().toString());
            if (opsRouter.getExternalGatewayInfo() != null) {
                Network network;
                String networkId = opsRouter.getExternalGatewayInfo().getNetworkId();
                if (networkInfo.get(networkId) != null) {
                    network = (Network)networkInfo.get(networkId);
                } else {
                    network = this.openstackTemplate.networking().network().get(networkId);
                    networkInfo.put(networkId, network);
                }
                builder.availabilityZones(network.getAvailabilityZones());
                builder.externalNetwork(network.getName());
            }
            Router router = builder.build();
            router.setId(opsRouter.getId());
            routerList.add(router);
        }
        return routerList;
    }
}

