/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.network.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.network.SecurityGroupService;
import cn.xphsc.openstack.core.entity.network.SecurityGroup;
import cn.xphsc.openstack.core.exception.OpenstackException;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstack4j.api.Builders;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.NetQuota;
import org.openstack4j.model.network.SecurityGroupRule;
import org.openstack4j.model.network.SecurityGroupUpdate;
import org.springframework.stereotype.Component;

@Component
public class SecurityGroupServiceImpl
implements SecurityGroupService {
    private final OpenstackTemplate openstackTemplate;

    public SecurityGroupServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public List<SecurityGroup> list() {
        return this.listByNameLike(null);
    }

    @Override
    public Page<SecurityGroup> list(PageQuery cloudPageQuery) {
        List<SecurityGroup> securityGroupList = this.listByNameLike(cloudPageQuery.getName());
        return PageImpl.of(securityGroupList, cloudPageQuery.getOffset(), cloudPageQuery.getLimit());
    }

    @Override
    public SecurityGroup get(String securityGroupId) {
        return this.translateSecurityGroup(this.openstackTemplate.networking().securitygroup().get(securityGroupId));
    }

    @Override
    public SecurityGroup create(SecurityGroup securityGroup) {
        try {
            String projectId = this.openstackTemplate.token().getProject().getId();
            NetQuota quota = this.openstackTemplate.networking().quotas().get(projectId);
            int totalSecurityGroupUsed = this.list().size();
            if (totalSecurityGroupUsed >= quota.getSecurityGroup()) {
                throw new OpenstackException("net.createFail.group.limit");
            }
            List<SecurityGroup> securityGroupList = this.listByNameLike(securityGroup.getName());
            if (securityGroupList.stream().anyMatch(existSecurityGroup -> existSecurityGroup.getName().equals(securityGroup.getName()))) {
                throw new OpenstackException("net.createFail.groupNameExit");
            }
            org.openstack4j.model.network.SecurityGroup createdSecurityGroup = this.openstackTemplate.networking().securitygroup().create((org.openstack4j.model.network.SecurityGroup)Builders.securityGroup().description(securityGroup.getDescription()).name(securityGroup.getName()).build());
            return this.translateSecurityGroup(createdSecurityGroup);
        }
        catch (ClientResponseException exception) {
            throw new OpenstackException(exception.getMessage());
        }
    }

    @Override
    public SecurityGroup update(SecurityGroup securityGroup) {
        try {
            List<SecurityGroup> securityGroupList = this.listByNameLike(securityGroup.getName());
            if (securityGroupList.stream().anyMatch(existSecurityGroup -> existSecurityGroup.getName().equals(securityGroup.getName()) && !existSecurityGroup.getId().equals(securityGroup.getId()))) {
                throw new OpenstackException("net.updateFail.groupNameExit");
            }
            org.openstack4j.model.network.SecurityGroup updatedSecurityGroup = this.openstackTemplate.networking().securitygroup().update(securityGroup.getId(), (SecurityGroupUpdate)Builders.securityGroupUpdate().name(securityGroup.getName()).description(securityGroup.getDescription()).build());
            return this.translateSecurityGroup(updatedSecurityGroup);
        }
        catch (ClientResponseException var4) {
            throw new OpenstackException(var4.getMessage());
        }
    }

    @Override
    public int delete(String securityGroupId) {
        ActionResponse actionResponse = this.openstackTemplate.networking().securitygroup().delete(securityGroupId);
        return actionResponse.isSuccess() ? 1 : 0;
    }

    @Override
    public int batchDelete(List<String> securityGroupIds) {
        for (String id : securityGroupIds) {
            this.openstackTemplate.networking().router().delete(id);
        }
        return 1;
    }

    @Override
    public int createRule(cn.xphsc.openstack.core.entity.network.SecurityGroupRule securityGroupRule) {
        try {
            SecurityGroupRule opsSecurityGroupRule = securityGroupRule.getPortRangeMax() != null && securityGroupRule.getPortRangeMin() != null ? (SecurityGroupRule)Builders.securityGroupRule().direction(securityGroupRule.getDirection()).ethertype(securityGroupRule.getEtherType()).protocol(securityGroupRule.getProtocol()).remoteIpPrefix(securityGroupRule.getRemoteIpPrefix()).remoteGroupId(securityGroupRule.getRemoteGroupId()).securityGroupId(securityGroupRule.getSecurityGroupId()).portRangeMax(securityGroupRule.getPortRangeMax().intValue()).portRangeMin(securityGroupRule.getPortRangeMin().intValue()).build() : (SecurityGroupRule)Builders.securityGroupRule().direction(securityGroupRule.getDirection()).ethertype(securityGroupRule.getEtherType()).protocol(securityGroupRule.getProtocol()).remoteIpPrefix(securityGroupRule.getRemoteIpPrefix()).remoteGroupId(securityGroupRule.getRemoteGroupId()).securityGroupId(securityGroupRule.getSecurityGroupId()).build();
            if (opsSecurityGroupRule == null) {
                return 0;
            }
            this.openstackTemplate.networking().securityrule().create(opsSecurityGroupRule);
        }
        catch (ClientResponseException var3) {
            return 0;
        }
        return 1;
    }

    @Override
    public List<cn.xphsc.openstack.core.entity.network.SecurityGroupRule> listRule(String securityGroupId) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        List<SecurityGroup> securityGroupList = this.list();
        for (SecurityGroup securityGroup : securityGroupList) {
            nameMap.put(securityGroup.getId(), securityGroup.getName());
        }
        ArrayList<cn.xphsc.openstack.core.entity.network.SecurityGroupRule> securityGroupRulesList = new ArrayList<cn.xphsc.openstack.core.entity.network.SecurityGroupRule>();
        List rulesList = this.openstackTemplate.networking().securitygroup().get(securityGroupId).getRules();
        for (SecurityGroupRule securityGroupRule : rulesList) {
            cn.xphsc.openstack.core.entity.network.SecurityGroupRule rule = new cn.xphsc.openstack.core.entity.network.SecurityGroupRule();
            rule.setName((String)nameMap.get(securityGroupRule.getId()));
            rule.setDirection(securityGroupRule.getDirection());
            rule.setEtherType(securityGroupRule.getEtherType());
            rule.setId(securityGroupRule.getId());
            rule.setPortRangeMax(securityGroupRule.getPortRangeMax());
            rule.setPortRangeMin(securityGroupRule.getPortRangeMin());
            rule.setProtocol(securityGroupRule.getProtocol());
            rule.setRemoteGroupId((String)nameMap.get(securityGroupRule.getRemoteGroupId()));
            rule.setRemoteIpPrefix(securityGroupRule.getRemoteIpPrefix());
            rule.setSecurityGroupId(securityGroupRule.getSecurityGroupId());
            securityGroupRulesList.add(rule);
        }
        return securityGroupRulesList;
    }

    @Override
    public int deleteRule(String ruleId) {
        this.openstackTemplate.networking().securityrule().delete(ruleId);
        return 1;
    }

    @Override
    public int batchDeleteRule(List<String> ruleIds) {
        for (String ruleId : ruleIds) {
            this.openstackTemplate.networking().securityrule().delete(ruleId);
        }
        return 1;
    }

    private List<SecurityGroup> listByNameLike(String name) {
        String projectId = this.openstackTemplate.token().getProject().getId();
        List<org.openstack4j.model.network.SecurityGroup> securitys = this.openstackTemplate.networking().securitygroup().list().stream().filter(security -> Strings.equals(projectId, security.getTenantId())).collect(Collectors.toList());
        ArrayList<SecurityGroup> securityGroupList = new ArrayList<SecurityGroup>();
        securitys.forEach(opsSecurityGroup -> {
            if (Strings.isEmpty(name) || !Strings.isEmpty(name) && opsSecurityGroup.getName().contains(name)) {
                securityGroupList.add(this.translateSecurityGroup((org.openstack4j.model.network.SecurityGroup)opsSecurityGroup));
            }
        });
        return securityGroupList;
    }

    private SecurityGroup translateSecurityGroup(org.openstack4j.model.network.SecurityGroup opsSecurityGroup) {
        if (Objects.isNull(opsSecurityGroup)) {
            return null;
        }
        SecurityGroup.Builder builder = SecurityGroup.builder();
        builder.name(opsSecurityGroup.getName());
        builder.description(opsSecurityGroup.getDescription());
        SecurityGroup securityGroup = builder.build();
        securityGroup.setId(opsSecurityGroup.getId());
        return securityGroup;
    }
}

