/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.network.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.network.SubnetService;
import cn.xphsc.openstack.core.entity.network.Subnet;
import cn.xphsc.openstack.core.paginator.Page;
import cn.xphsc.openstack.core.paginator.PageImpl;
import cn.xphsc.openstack.core.query.PageQuery;
import cn.xphsc.openstack.utils.CollectionUtils;
import cn.xphsc.openstack.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openstack4j.api.Builders;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.IPVersionType;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.Pool;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.model.network.builder.SubnetBuilder;
import org.springframework.stereotype.Component;

@Component
public class SubnetServiceImpl
implements SubnetService {
    private final OpenstackTemplate openstackTemplate;

    public SubnetServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public cn.xphsc.openstack.core.entity.network.Subnet get(String subnetId) {
        return this.translateSubnet(this.openstackTemplate.networking().subnet().get(subnetId));
    }

    @Override
    public List<cn.xphsc.openstack.core.entity.network.Subnet> list(String networkId) {
        List opsSubnetList;
        if (Strings.isEmpty(networkId)) {
            opsSubnetList = this.openstackTemplate.networking().subnet().list();
        } else {
            Network network = this.openstackTemplate.networking().network().get(networkId);
            opsSubnetList = network.getNeutronSubnets();
        }
        ArrayList<cn.xphsc.openstack.core.entity.network.Subnet> subnetList = new ArrayList<cn.xphsc.openstack.core.entity.network.Subnet>();
        for (Subnet subnet : opsSubnetList) {
            subnetList.add(this.translateSubnet(subnet));
        }
        return subnetList;
    }

    @Override
    public Page<cn.xphsc.openstack.core.entity.network.Subnet> list(PageQuery pageQuery, String networkId) {
        return PageImpl.of(this.list(networkId), pageQuery.getOffset(), pageQuery.getLimit());
    }

    @Override
    public int delete(String subnetId) {
        ActionResponse actionResponse = this.openstackTemplate.networking().subnet().delete(subnetId);
        return actionResponse.isSuccess() ? 1 : 0;
    }

    @Override
    public cn.xphsc.openstack.core.entity.network.Subnet create(cn.xphsc.openstack.core.entity.network.Subnet subnet) {
        try {
            SubnetBuilder builder = this.setBuilder(subnet);
            Subnet opsSubnet = this.openstackTemplate.networking().subnet().create((Subnet)builder.build());
            return this.translateSubnet(opsSubnet);
        }
        catch (ClientResponseException var4) {
            return null;
        }
    }

    private SubnetBuilder setBuilder(cn.xphsc.openstack.core.entity.network.Subnet subnet) {
        SubnetBuilder builder = Builders.subnet().name(subnet.getName()).cidr(subnet.getCidr()).networkId(subnet.getNetworkId()).enableDHCP(subnet.getEnableDhcp().booleanValue());
        if (Boolean.TRUE.equals(subnet.getDisableGateway())) {
            builder.noGateway();
        } else if (!Strings.isEmpty(subnet.getGateway())) {
            builder.gateway(subnet.getGateway());
        }
        if (subnet.getIpVersion() == 1) {
            builder.ipVersion(IPVersionType.V4);
        } else {
            builder.ipVersion(IPVersionType.V6);
        }
        List<cn.xphsc.openstack.core.entity.network.Pool> pools = subnet.getPools();
        if (Objects.nonNull(pools)) {
            pools.forEach(pool -> builder.addPool(pool.getStart(), pool.getEnd()));
        }
        this.setBuilderDns(subnet.getDns(), builder);
        return builder;
    }

    private void setBuilderDns(List<String> dnsNames, SubnetBuilder builder) {
        if (!CollectionUtils.isEmpty(dnsNames)) {
            for (String dns : dnsNames) {
                builder.addDNSNameServer(dns);
            }
        }
    }

    public cn.xphsc.openstack.core.entity.network.Subnet translateSubnet(Subnet opsSubnet) {
        Subnet.Builder subnet = cn.xphsc.openstack.core.entity.network.Subnet.builder();
        subnet.name(opsSubnet.getName());
        subnet.cidr(opsSubnet.getCidr());
        subnet.dns(opsSubnet.getDnsNames());
        subnet.networkId(opsSubnet.getNetworkId());
        subnet.enableDhcp(opsSubnet.isDHCPEnabled());
        subnet.gateway(opsSubnet.getGateway());
        subnet.ipVersion(opsSubnet.getIpVersion().getVersion());
        ArrayList<cn.xphsc.openstack.core.entity.network.Pool> pools = new ArrayList<cn.xphsc.openstack.core.entity.network.Pool>();
        Pool pool = (Pool)opsSubnet.getAllocationPools().get(0);
        cn.xphsc.openstack.core.entity.network.Pool newPool = cn.xphsc.openstack.core.entity.network.Pool.builder().build();
        newPool.setStart(pool.getStart());
        newPool.setEnd(pool.getEnd());
        pools.add(newPool);
        subnet.pools(pools);
        cn.xphsc.openstack.core.entity.network.Subnet newSubnet = subnet.build();
        newSubnet.setId(opsSubnet.getId());
        newSubnet.setTenantId(opsSubnet.getTenantId());
        return newSubnet;
    }
}

