/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.network.service;

import cn.xphsc.openstack.core.client.network.VpnService;
import cn.xphsc.openstack.core.entity.network.VpnConnect;
import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import org.springframework.stereotype.Component;

@Component
public class VpnServiceImpl
extends BaseNetworkingServices
implements VpnService {
    public static final String URL_WITH_ROUTER_PARAM = "/vpn/openconnects/%s";

    @Override
    public VpnConnect create(VpnConnect vpnConnection) {
        Preconditions.checkNotNull((Object)vpnConnection);
        return (VpnConnect)this.post(VpnConnect.class, new String[]{this.uri("/vpn/openconnects", new Object[0])}).entity((ModelEntity)vpnConnection).execute();
    }

    @Override
    public VpnConnect get(String routerId) {
        Preconditions.checkNotNull((Object)routerId);
        return (VpnConnect)this.get(VpnConnect.class, new String[]{this.uri(URL_WITH_ROUTER_PARAM, new Object[]{routerId})}).execute();
    }

    @Override
    public List<VpnConnect> list() {
        return ((VpnConnect.OpenConnects)((Object)this.get(VpnConnect.OpenConnects.class, new String[]{this.uri("/vpn/openconnects", new Object[0])}).execute())).getList();
    }

    @Override
    public VpnConnect start(String routerId) {
        Preconditions.checkNotNull((Object)routerId);
        VpnConnect openConnect = VpnConnect.builder().routerId(routerId).adminStateUp(true).build();
        return (VpnConnect)this.put(VpnConnect.class, new String[]{this.uri(URL_WITH_ROUTER_PARAM, new Object[]{routerId})}).entity((ModelEntity)openConnect).execute();
    }

    @Override
    public VpnConnect stop(String routerId) {
        Preconditions.checkNotNull((Object)routerId);
        VpnConnect openConnect = VpnConnect.builder().routerId(routerId).adminStateUp(false).build();
        return (VpnConnect)this.put(VpnConnect.class, new String[]{this.uri(URL_WITH_ROUTER_PARAM, new Object[]{routerId})}).entity((ModelEntity)openConnect).execute();
    }

    @Override
    public int delete(String routerId) {
        Preconditions.checkNotNull((Object)routerId);
        ActionResponse actionResponse = (ActionResponse)this.deleteWithResponse(new String[]{this.uri(URL_WITH_ROUTER_PARAM, new Object[]{routerId})}).execute();
        return actionResponse.isSuccess() ? 1 : 0;
    }
}

