/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.client.volume.service;

import cn.xphsc.openstack.core.OpenstackTemplate;
import cn.xphsc.openstack.core.client.volume.VolumeService;
import cn.xphsc.openstack.core.entity.compute.Snapshot;
import cn.xphsc.openstack.core.entity.volume.VolumeStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.block.Volume;
import org.openstack4j.model.storage.block.VolumeUploadImage;
import org.openstack4j.model.storage.block.options.UploadImageData;
import org.openstack4j.openstack.storage.block.domain.CinderVolume;
import org.springframework.stereotype.Component;

@Component
public class VolumeServiceImpl
implements VolumeService {
    private final OpenstackTemplate openstackTemplate;

    public VolumeServiceImpl(OpenstackTemplate openstackTemplate) {
        this.openstackTemplate = openstackTemplate;
    }

    @Override
    public cn.xphsc.openstack.core.entity.volume.Volume get(String volumeId) {
        Volume volume = this.openstackTemplate.blockStorage().volumes().get(volumeId);
        return this.translateVolume(volume);
    }

    @Override
    public String uploadToImage(String volumeId, String imageName) {
        UploadImageData uploadImageData = UploadImageData.create((String)imageName);
        VolumeUploadImage volumeUploadImage = this.openstackTemplate.blockStorage().volumes().uploadToImage(volumeId, uploadImageData);
        return volumeUploadImage.getImageId();
    }

    @Override
    public int delete(String volumeId) {
        ActionResponse response = this.openstackTemplate.blockStorage().volumes().delete(volumeId);
        return response.isSuccess() ? 1 : 0;
    }

    @Override
    public int bootable(String volumeId, boolean bootable) {
        ActionResponse response = this.openstackTemplate.blockStorage().volumes().bootable(volumeId, Boolean.valueOf(bootable));
        return response.isSuccess() ? 1 : 0;
    }

    @Override
    public cn.xphsc.openstack.core.entity.volume.Volume create(Snapshot snapshot) {
        Volume volumeBuilder = (Volume)CinderVolume.builder().name("").snapshot(snapshot.getId()).size(snapshot.getSize().intValue()).build();
        Volume volume = this.openstackTemplate.blockStorage().volumes().create(volumeBuilder);
        return this.translateVolume(volume);
    }

    private cn.xphsc.openstack.core.entity.volume.Volume translateVolume(Volume volume) {
        cn.xphsc.openstack.core.entity.volume.Volume newVolume = cn.xphsc.openstack.core.entity.volume.Volume.builder().id(volume.getId()).name(volume.getName()).description(volume.getDescription()).size(volume.getSize()).bootable(volume.bootable()).encrypted(volume.encrypted()).imageRef(volume.getImageRef() != null ? volume.getImageRef() : null).multiattach(volume.multiattach() != null ? volume.multiattach() : null).status(VolumeStatus.fromValue(volume.getStatus().name())).build();
        return newVolume;
    }
}

