/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.entity.compute;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class InterfaceAttachmentPort {
    @JsonProperty(value="fixed_ips")
    private List<FixedIp> fixedIps;
    @JsonProperty(value="mac_addr")
    private String macAddr;
    @JsonProperty(value="net_id")
    private String netId;
    @JsonProperty(value="port_id")
    private String portId;
    @JsonProperty(value="port_state")
    private PortState portState;

    public static Builder builder() {
        return new Builder();
    }

    private InterfaceAttachmentPort(Builder builder) {
        this.fixedIps = builder.fixedIps;
        this.macAddr = builder.macAddr;
        this.netId = builder.netId;
        this.portId = builder.portId;
        this.portState = builder.portState;
    }

    public List<FixedIp> getFixedIps() {
        return this.fixedIps;
    }

    public String getMacAddr() {
        return this.macAddr;
    }

    public String getNetId() {
        return this.netId;
    }

    public String getPortId() {
        return this.portId;
    }

    public PortState getPortState() {
        return this.portState;
    }

    public static enum PortState {
        ACTIVE,
        DOWN,
        BUILD,
        ERROR,
        UNRECOGNIZED;


        @JsonCreator
        public static PortState forValue(String value) {
            if (value != null) {
                for (PortState s : PortState.values()) {
                    if (!s.name().equalsIgnoreCase(value)) continue;
                    return s;
                }
            }
            return UNRECOGNIZED;
        }
    }

    public static class FixedIp {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="ip_address")
        private String ipAddress;
        @JsonProperty(value="subnet_id")
        private String subnetId;

        public static Builder builder() {
            return new Builder();
        }

        private FixedIp(Builder builder) {
            this.ipAddress = builder.ipAddress;
            this.subnetId = builder.subnetId;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getSubnetId() {
            return this.subnetId;
        }

        public static class Builder {
            private String ipAddress;
            private String subnetId;

            public <T> Builder ipAddress(String ipAddress) {
                this.ipAddress = ipAddress;
                return this;
            }

            public <T> Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public FixedIp build() {
                return new FixedIp(this);
            }
        }
    }

    public static class Builder {
        private List<FixedIp> fixedIps;
        private String macAddr;
        private String netId;
        private String portId;
        private PortState portState;

        public <T> Builder fixedIps(List<FixedIp> fixedIps) {
            this.fixedIps = fixedIps;
            return this;
        }

        public <T> Builder macAddr(String macAddr) {
            this.macAddr = macAddr;
            return this;
        }

        public <T> Builder netId(String netId) {
            this.netId = netId;
            return this;
        }

        public <T> Builder portId(String portId) {
            this.portId = portId;
            return this;
        }

        public <T> Builder portState(PortState portState) {
            this.portState = portState;
            return this;
        }

        public InterfaceAttachmentPort build() {
            return new InterfaceAttachmentPort(this);
        }
    }
}

