/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.entity.compute;

import cn.xphsc.openstack.core.entity.ModelEntity;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

public class Snapshot
extends ModelEntity {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="size")
    private Integer size = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;

    public static Builder builder() {
        return new Builder();
    }

    private Snapshot(Builder builder) {
        this.name = builder.name;
        this.size = builder.size;
        this.status = builder.status;
    }

    public String getName() {
        return this.name;
    }

    public Integer getSize() {
        return this.size;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public static enum StatusEnum {
        AVAILABLE("AVAILABLE"),
        ATTACHING("ATTACHING"),
        BACKING_UP("BACKING_UP"),
        CREATING("CREATING"),
        DELETING("DELETING"),
        DOWNLOADING("DOWNLOADING"),
        UPLOADING("UPLOADING"),
        ERROR("ERROR"),
        ERROR_DELETING("ERROR_DELETING"),
        ERROR_RESTORING("ERROR_RESTORING"),
        IN_USE("IN_USE"),
        RESTORING_BACKUP("RESTORING_BACKUP"),
        DETACHING("DETACHING"),
        UNRECOGNIZED("UNRECOGNIZED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static class Builder {
        private String name = null;
        private Integer size = null;
        private StatusEnum status = null;

        public <T> Builder name(String name) {
            this.name = name;
            return this;
        }

        public <T> Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public <T> Builder status(StatusEnum status) {
            this.status = status;
            return this;
        }

        public Snapshot build() {
            return new Snapshot(this);
        }
    }
}

