/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.entity.container;

import cn.xphsc.openstack.core.entity.container.AppContainerAddress;
import cn.xphsc.openstack.core.entity.container.DockerStatus;
import cn.xphsc.openstack.core.entity.net.Net;
import cn.xphsc.openstack.core.entity.network.FloatingIp;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class Container {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="status")
    private DockerStatus status = null;
    @JsonProperty(value="status_detail")
    private String statusDetail = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="image")
    private String image = null;
    @JsonProperty(value="image_driver")
    private String imageDriver = null;
    @JsonProperty(value="privileged")
    private Boolean privileged = null;
    private String cmd;
    @JsonProperty(value="image_pull_policy")
    private String imagePullPolicy;
    private Float cpu;
    @JsonProperty(value="memory")
    private String memory;
    @JsonProperty(value="nets")
    private List<Net> nets = null;
    @JsonProperty(value="float_ip")
    private FloatingIp floatIp = null;
    @JsonProperty(value="security_groups")
    private List<String> securityGroups = null;
    @JsonProperty(value="ports")
    private List<Integer> ports = null;
    @JsonProperty(value="address")
    private List<AppContainerAddress> address = null;

    public static Builder builder() {
        return new Builder();
    }

    private Container(Builder builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.statusDetail = builder.statusDetail;
        this.name = builder.name;
        this.image = builder.image;
        this.imageDriver = builder.imageDriver;
        this.privileged = builder.privileged;
        this.cmd = builder.cmd;
        this.imagePullPolicy = builder.imagePullPolicy;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.nets = builder.nets;
        this.floatIp = builder.floatIp;
        this.securityGroups = builder.securityGroups;
        this.ports = builder.ports;
        this.address = builder.address;
    }

    public String getId() {
        return this.id;
    }

    public DockerStatus getStatus() {
        return this.status;
    }

    public String getStatusDetail() {
        return this.statusDetail;
    }

    public String getName() {
        return this.name;
    }

    public String getImage() {
        return this.image;
    }

    public String getImageDriver() {
        return this.imageDriver;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public Float getCpu() {
        return this.cpu;
    }

    public String getMemory() {
        return this.memory;
    }

    public List<Net> getNets() {
        return this.nets;
    }

    public FloatingIp getFloatIp() {
        return this.floatIp;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public List<AppContainerAddress> getAddress() {
        return this.address;
    }

    public static class Builder {
        private String id = null;
        private DockerStatus status = null;
        private String statusDetail = null;
        private String name = null;
        private String image = null;
        private String imageDriver = null;
        private Boolean privileged = null;
        private String cmd;
        private String imagePullPolicy;
        private Float cpu;
        private String memory;
        private List<Net> nets = null;
        private FloatingIp floatIp = null;
        private List<String> securityGroups = null;
        private List<Integer> ports = null;
        private List<AppContainerAddress> address = null;

        public <T> Builder id(String id) {
            this.id = id;
            return this;
        }

        public <T> Builder status(DockerStatus status) {
            this.status = status;
            return this;
        }

        public <T> Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public <T> Builder name(String name) {
            this.name = name;
            return this;
        }

        public <T> Builder image(String image) {
            this.image = image;
            return this;
        }

        public <T> Builder imageDriver(String imageDriver) {
            this.imageDriver = imageDriver;
            return this;
        }

        public <T> Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public <T> Builder cmd(String cmd) {
            this.cmd = cmd;
            return this;
        }

        public <T> Builder imagePullPolicy(String imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
            return this;
        }

        public <T> Builder cpu(Float cpu) {
            this.cpu = cpu;
            return this;
        }

        public <T> Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public <T> Builder nets(List<Net> nets) {
            this.nets = nets;
            return this;
        }

        public <T> Builder floatIp(FloatingIp floatIp) {
            this.floatIp = floatIp;
            return this;
        }

        public <T> Builder securityGroups(List<String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public <T> Builder ports(List<Integer> ports) {
            this.ports = ports;
            return this;
        }

        public <T> Builder address(List<AppContainerAddress> address) {
            this.address = address;
            return this;
        }

        public Container build() {
            return new Container(this);
        }
    }
}

