/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.entity.container;

import cn.xphsc.openstack.core.entity.container.Appcontainer;
import cn.xphsc.openstack.core.entity.container.AppcontainerBuilder;
import cn.xphsc.openstack.core.entity.container.Status;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.common.builder.BasicResourceBuilder;
import org.openstack4j.openstack.common.ListResult;

public class ZunAppcontainer
implements Appcontainer {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="uuid")
    private String id;
    private String name;
    private String image;
    @JsonProperty(value="image_driver")
    private String imageDriver;
    @JsonProperty(value="command", access=JsonProperty.Access.READ_ONLY)
    private String cmd;
    @JsonProperty(value="command", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> cmdArray;
    @JsonProperty(value="workdir")
    private String workDir;
    @JsonProperty(value="hostname")
    private String hostName;
    @JsonProperty(value="image_pull_policy")
    private String imagePullPolicy;
    @JsonProperty(value="status_detail")
    private String statusDetail;
    private Float cpu;
    private String memory;
    private boolean privileged;
    private boolean interactive;
    private String host;
    @JsonProperty(value="auto_remove")
    private boolean autoRemove;
    @JsonProperty(value="security_groups")
    private List<String> securityGroups;
    private Map<String, String> environment;
    private Map<String, String> labels;
    private List<Integer> ports;
    private Map<String, List<AppSubnet>> addresses;
    private Status status;
    @JsonProperty(value="nets")
    private List<Map<String, Object>> nets;
    @JsonProperty(value="restart_policy")
    private AppRestartPolicy restartPolicy;

    public static AppcontainerBuilder builder() {
        return new AppcontainerConcreteBuilder();
    }

    public AppcontainerBuilder toBuilder() {
        return new AppcontainerConcreteBuilder(this);
    }

    @Override
    public String getStatusDetail() {
        return this.statusDetail;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public String getImageDriver() {
        return this.imageDriver;
    }

    @Override
    public String getCmd() {
        return this.cmd;
    }

    @Override
    public String getWorkDir() {
        return this.workDir;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Override
    public Float getCpu() {
        return this.cpu;
    }

    @Override
    public String getMemory() {
        return this.memory;
    }

    @Override
    public boolean isPrivileged() {
        return this.privileged;
    }

    @Override
    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    public boolean isAutoRemove() {
        return this.autoRemove;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    public List<Integer> getPorts() {
        return this.ports;
    }

    @Override
    public Map<String, List<AppSubnet>> getAddresses() {
        return this.addresses;
    }

    @Override
    public AppRestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("image", (Object)this.image).add("imageDriver", (Object)this.imageDriver).add("command", this.cmdArray).add("workDir", (Object)this.workDir).add("hostname", (Object)this.hostName).add("imagePullPolicy", (Object)this.imagePullPolicy).add("cpu", (Object)this.cpu).add("memory", (Object)this.memory).add("privileged", this.privileged).add("interactive", this.interactive).add("autoRemove", this.autoRemove).add("securityGroups", this.securityGroups).add("environment", this.environment).add("label", this.labels).add("host", (Object)this.host).add("ports", this.ports).add("addresses", this.addresses).add("status", (Object)this.status).add("status_detail", (Object)this.statusDetail).toString();
    }

    public static class AppRestartPolicy {
        public String Name;
        public int MaximumRetryCount;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("Name", (Object)this.Name).add("MaximumRetryCount", this.MaximumRetryCount).toString();
        }
    }

    public static class AppSubnet {
        public String addr;
        public String port;
        public Boolean preserve_on_delete;
        public String subnet_id;
        public Integer version;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("addr", (Object)this.addr).add("port", (Object)this.port).add("preserve_on_delete", (Object)this.preserve_on_delete).add("subnet_id", (Object)this.subnet_id).add("version", (Object)this.version).toString();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Appcontainers
    extends ListResult<ZunAppcontainer> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="containers")
        private List<ZunAppcontainer> appcontainers;

        protected List<ZunAppcontainer> value() {
            return this.appcontainers;
        }
    }

    public static class AppcontainerConcreteBuilder
    extends BasicResourceBuilder<Appcontainer, AppcontainerConcreteBuilder>
    implements AppcontainerBuilder {
        private ZunAppcontainer m;

        AppcontainerConcreteBuilder() {
            this(new ZunAppcontainer());
        }

        AppcontainerConcreteBuilder(ZunAppcontainer m) {
            this.m = m;
        }

        @Override
        public AppcontainerBuilder image(String image) {
            this.m.image = image;
            return this;
        }

        @Override
        public AppcontainerBuilder imageDriver(String imageDriver) {
            this.m.imageDriver = imageDriver;
            return this;
        }

        @Override
        public AppcontainerBuilder cmd(String cmd) {
            this.m.cmd = cmd;
            return this;
        }

        @Override
        public AppcontainerBuilder workDir(String dir) {
            this.m.workDir = dir;
            return this;
        }

        @Override
        public AppcontainerBuilder hostname(String hostName) {
            this.m.hostName = hostName;
            return this;
        }

        @Override
        public AppcontainerBuilder host(String host) {
            this.m.host = host;
            return this;
        }

        @Override
        public AppcontainerBuilder cpu(Float cpuCount) {
            this.m.cpu = cpuCount;
            return this;
        }

        @Override
        public AppcontainerBuilder memory(String memorySize) {
            this.m.memory = memorySize;
            return this;
        }

        @Override
        public AppcontainerBuilder interactive(boolean interactive) {
            this.m.interactive = interactive;
            return this;
        }

        @Override
        public AppcontainerBuilder autoRemove(boolean autoRemove) {
            this.m.autoRemove = autoRemove;
            return this;
        }

        @Override
        public AppcontainerBuilder securityGroups(List<String> groups) {
            this.m.securityGroups = groups;
            return this;
        }

        @Override
        public AppcontainerBuilder environment(Map<String, String> envs) {
            this.m.environment = envs;
            return this;
        }

        @Override
        public AppcontainerBuilder labels(Map<String, String> labels) {
            this.m.labels = labels;
            return this;
        }

        @Override
        public AppcontainerBuilder network(String net) {
            HashMap<String, String> mNet = new HashMap<String, String>();
            mNet.put("network", net);
            if (this.m.nets == null) {
                this.m.nets = new ArrayList();
            }
            this.m.nets.add(mNet);
            return this;
        }

        @Override
        public AppcontainerBuilder privileged(Boolean privileged) {
            this.m.privileged = privileged;
            return this;
        }

        public AppcontainerBuilder ports(List<Integer> ports) {
            this.m.ports = ports;
            return this;
        }

        @Override
        public AppcontainerBuilder port(String port) {
            HashMap<String, String> mPort = new HashMap<String, String>();
            mPort.put("port", port);
            if (this.m.nets == null) {
                this.m.nets = new ArrayList();
            }
            this.m.nets.add(mPort);
            return this;
        }

        @Override
        public AppcontainerBuilder restartPolicy(String name, int maximumRetryCount) {
            AppRestartPolicy appRestartPolicy = new AppRestartPolicy();
            appRestartPolicy.Name = name;
            appRestartPolicy.MaximumRetryCount = maximumRetryCount;
            this.m.restartPolicy = appRestartPolicy;
            return this;
        }

        public Appcontainer build() {
            return this.m;
        }

        public AppcontainerBuilder from(Appcontainer in) {
            this.m = (ZunAppcontainer)in;
            return this;
        }

        protected Appcontainer reference() {
            return this.m;
        }
    }
}

