/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.entity.net;

import cn.xphsc.openstack.core.entity.net.Acl;
import cn.xphsc.openstack.core.entity.network.QoS;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

public class Net {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="net_id")
    private String netId = null;
    @JsonProperty(value="private_ip")
    private String privateIp = null;
    @JsonProperty(value="cidr")
    private String cidr = null;
    @JsonProperty(value="ip_version")
    private IpVersionEnum ipVersion = null;
    @JsonProperty(value="index")
    private Integer index = null;
    @JsonProperty(value="external")
    private Boolean external = false;
    @JsonProperty(value="public_ip")
    private String publicIp = null;
    @JsonProperty(value="qos")
    private QoS qos = null;
    @JsonProperty(value="security")
    private Acl security = null;
    @JsonProperty(value="port_id")
    private String portId = null;
    @JsonProperty(value="mac_address")
    private String macAddress = null;
    @JsonProperty(value="default_router")
    private Boolean defaultRouter = null;

    public static Builder builder() {
        return new Builder();
    }

    private Net(Builder builder) {
        this.id = builder.id;
        this.netId = builder.netId;
        this.privateIp = builder.privateIp;
        this.cidr = builder.cidr;
        this.ipVersion = builder.ipVersion;
        this.index = builder.index;
        this.external = builder.external;
        this.publicIp = builder.publicIp;
        this.qos = builder.qos;
        this.security = builder.security;
        this.portId = builder.portId;
        this.macAddress = builder.macAddress;
        this.defaultRouter = builder.defaultRouter;
    }

    public String getId() {
        return this.id;
    }

    public String getNetId() {
        return this.netId;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public String getCidr() {
        return this.cidr;
    }

    public IpVersionEnum getIpVersion() {
        return this.ipVersion;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Boolean getExternal() {
        return this.external;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public QoS getQos() {
        return this.qos;
    }

    public Acl getSecurity() {
        return this.security;
    }

    public String getPortId() {
        return this.portId;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public Boolean getDefaultRouter() {
        return this.defaultRouter;
    }

    public static enum IpVersionEnum {
        IPV4("ipv4"),
        IPV6("ipv6");

        private String value;

        private IpVersionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IpVersionEnum fromValue(String text) {
            for (IpVersionEnum b : IpVersionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static class Builder {
        private String id = null;
        private String netId = null;
        private String privateIp = null;
        private String cidr = null;
        private IpVersionEnum ipVersion = null;
        private Integer index = null;
        private Boolean external = false;
        private String publicIp = null;
        private QoS qos = null;
        private Acl security = null;
        private String portId = null;
        private String macAddress = null;
        private Boolean defaultRouter = null;

        public <T> Builder id(String id) {
            this.id = id;
            return this;
        }

        public <T> Builder netId(String netId) {
            this.netId = netId;
            return this;
        }

        public <T> Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public <T> Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public <T> Builder ipVersion(IpVersionEnum ipVersion) {
            this.ipVersion = ipVersion;
            return this;
        }

        public <T> Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public <T> Builder external(Boolean external) {
            this.external = external;
            return this;
        }

        public <T> Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public <T> Builder qos(QoS qos) {
            this.qos = qos;
            return this;
        }

        public <T> Builder security(Acl security) {
            this.security = security;
            return this;
        }

        public <T> Builder portId(String portId) {
            this.portId = portId;
            return this;
        }

        public <T> Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public <T> Builder defaultRouter(Boolean defaultRouter) {
            this.defaultRouter = defaultRouter;
            return this;
        }

        public Net build() {
            return new Net(this);
        }
    }
}

