/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.entity.network;

import cn.xphsc.openstack.core.entity.ModelEntity;
import cn.xphsc.openstack.core.entity.network.NetworkType;
import cn.xphsc.openstack.core.entity.network.Subnet;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class Network
extends ModelEntity {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="type")
    private NetworkType type = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="is_shared")
    private Boolean isShared = null;
    @JsonProperty(value="is_external")
    private Boolean isExternal = null;
    @JsonProperty(value="is_admin_state_up")
    private Boolean isAdminStateUp = null;
    @JsonProperty(value="segment_id")
    private String segmentId = null;
    @JsonProperty(value="availability_zones")
    private List<String> availabilityZones = null;
    @JsonProperty(value="subnet")
    private List<Subnet> subnet = null;
    @JsonProperty(value="vlan")
    private String vlan = null;
    @JsonProperty(value="physical_net")
    private String physicalNet = null;
    private String cidr = null;
    @JsonProperty(value="network_type")
    private String networkType;
    private Boolean portSecurityEnabled;

    public static Builder builder() {
        return new Builder();
    }

    private Network(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.status = builder.status;
        this.isShared = builder.isShared;
        this.isExternal = builder.isExternal;
        this.isAdminStateUp = builder.isAdminStateUp;
        this.segmentId = builder.segmentId;
        this.availabilityZones = builder.availabilityZones;
        this.subnet = builder.subnet;
        this.vlan = builder.vlan;
        this.physicalNet = builder.physicalNet;
        this.cidr = builder.cidr;
        this.networkType = builder.networkType;
        this.setId(builder.networkId);
        this.portSecurityEnabled = builder.portSecurityEnabled;
    }

    public String getName() {
        return this.name;
    }

    public NetworkType getType() {
        return this.type;
    }

    public String getStatus() {
        return this.status;
    }

    public Boolean getShared() {
        return this.isShared;
    }

    public Boolean getExternal() {
        return this.isExternal;
    }

    public Boolean getAdminStateUp() {
        return this.isAdminStateUp;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public List<Subnet> getSubnet() {
        return this.subnet;
    }

    public String getVlan() {
        return this.vlan;
    }

    public String getPhysicalNet() {
        return this.physicalNet;
    }

    public String getCidr() {
        return this.cidr;
    }

    public Boolean getPortSecurityEnabled() {
        return this.portSecurityEnabled;
    }

    public Network addSubnetItem(Subnet subnetItem) {
        if (this.subnet == null) {
            this.subnet = new ArrayList<Subnet>();
        }
        this.subnet.add(subnetItem);
        return this;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public static class Builder {
        private String name = null;
        private String networkId = null;
        private NetworkType type = null;
        private String status = null;
        private Boolean isShared = null;
        private Boolean isExternal = null;
        private Boolean isAdminStateUp = null;
        private String segmentId = null;
        private List<String> availabilityZones = null;
        private List<Subnet> subnet = null;
        private String vlan = null;
        private String physicalNet = null;
        private String cidr = null;
        private String networkType;
        private Boolean portSecurityEnabled;

        public <T> Builder name(String name) {
            this.name = name;
            return this;
        }

        public <T> Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public <T> Builder type(NetworkType type) {
            this.type = type;
            return this;
        }

        public <T> Builder status(String status) {
            this.status = status;
            return this;
        }

        public <T> Builder isShared(Boolean isShared) {
            this.isShared = isShared;
            return this;
        }

        public <T> Builder isExternal(Boolean isExternal) {
            this.isExternal = isExternal;
            return this;
        }

        public <T> Builder isAdminStateUp(Boolean isAdminStateUp) {
            this.isAdminStateUp = isAdminStateUp;
            return this;
        }

        public <T> Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public <T> Builder availabilityZones(List<String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        public <T> Builder subnet(List<Subnet> subnet) {
            this.subnet = subnet;
            return this;
        }

        public <T> Builder vlan(String vlan) {
            this.vlan = vlan;
            return this;
        }

        public <T> Builder physicalNet(String physicalNet) {
            this.physicalNet = physicalNet;
            return this;
        }

        public <T> Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public <T> Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public <T> Builder portSecurityEnabled(Boolean portSecurityEnabled) {
            this.portSecurityEnabled = portSecurityEnabled;
            return this;
        }

        public Network build() {
            return new Network(this);
        }
    }
}

