/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.entity.network.gateway;

import cn.xphsc.openstack.core.entity.network.gateway.Device;
import cn.xphsc.openstack.core.entity.network.gateway.DeviceImpl;
import cn.xphsc.openstack.core.entity.network.gateway.L2Gateway;
import cn.xphsc.openstack.core.entity.network.gateway.L2GatewayBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.openstack4j.openstack.common.ListResult;

public class L2GatewayImpl
implements L2Gateway {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="devices")
    private List<DeviceImpl> devices;

    public L2GatewayImpl() {
    }

    public L2GatewayImpl(String id, String name, String tenantId, List<DeviceImpl> devices) {
        this.id = id;
        this.name = name;
        this.tenantId = tenantId;
        this.devices = devices;
    }

    public static L2GatewayBuilder builder() {
        return new L2GatewayConcreteBuilder();
    }

    public L2GatewayBuilder toBuilder() {
        return new L2GatewayConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public List<? extends Device> getDevices() {
        return this.devices;
    }

    public static class L2Gateways
    extends ListResult<L2GatewayImpl> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="l2_gateways")
        private List<L2GatewayImpl> l2Gateways;

        public List<L2GatewayImpl> value() {
            return this.l2Gateways;
        }
    }

    public static class L2GatewayConcreteBuilder
    implements L2GatewayBuilder {
        private L2GatewayImpl model;

        public L2GatewayConcreteBuilder() {
            this(new L2GatewayImpl());
        }

        public L2GatewayConcreteBuilder(L2GatewayImpl model) {
            this.model = model;
        }

        public L2Gateway build() {
            return this.model;
        }

        public L2GatewayBuilder from(L2Gateway in) {
            if (in != null) {
                this.model = (L2GatewayImpl)in;
            }
            return this;
        }

        @Override
        public L2GatewayBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public L2GatewayBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public L2GatewayBuilder tenantId(String tenantId) {
            this.model.tenantId = tenantId;
            return this;
        }

        @Override
        public L2GatewayBuilder devices(List<DeviceImpl> devices) {
            this.model.devices = devices;
            return this;
        }
    }
}

