/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.entity.volume;

import cn.xphsc.openstack.core.entity.volume.VolumeStatus;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Volume {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="status")
    private VolumeStatus status = null;
    @JsonProperty(value="size")
    private Integer size = null;
    @JsonProperty(value="bootable")
    private Boolean bootable = null;
    @JsonProperty(value="encrypted")
    private Boolean encrypted = null;
    private String imageRef;
    private Boolean multiattach;

    public static Builder builder() {
        return new Builder();
    }

    private Volume(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.size = builder.size;
        this.bootable = builder.bootable;
        this.encrypted = builder.encrypted;
        this.imageRef = builder.imageRef;
        this.multiattach = builder.multiattach;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public VolumeStatus getStatus() {
        return this.status;
    }

    public Integer getSize() {
        return this.size;
    }

    public Boolean getBootable() {
        return this.bootable;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public String getImageRef() {
        return this.imageRef;
    }

    public Boolean getMultiattach() {
        return this.multiattach;
    }

    public static class Builder {
        private String id = null;
        private String name = null;
        private String description = null;
        private VolumeStatus status = null;
        private Integer size = null;
        private Boolean bootable = null;
        private Boolean encrypted = null;
        private String imageRef;
        private Boolean multiattach;

        public <T> Builder id(String id) {
            this.id = id;
            return this;
        }

        public <T> Builder name(String name) {
            this.name = name;
            return this;
        }

        public <T> Builder description(String description) {
            this.description = description;
            return this;
        }

        public <T> Builder status(VolumeStatus status) {
            this.status = status;
            return this;
        }

        public <T> Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public <T> Builder bootable(Boolean bootable) {
            this.bootable = bootable;
            return this;
        }

        public <T> Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public <T> Builder imageRef(String imageRef) {
            this.imageRef = imageRef;
            return this;
        }

        public <T> Builder multiattach(Boolean multiattach) {
            this.multiattach = multiattach;
            return this;
        }

        public Volume build() {
            return new Volume(this);
        }
    }
}

