/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.exception;

import java.lang.reflect.Type;

public class DeserializationException
extends RuntimeException {
    public static final int ERROR_CODE = 101;
    private static final long serialVersionUID = -2742350751684273728L;
    private Class<?> targetClass;
    public static final String ERROR_MESSAGE_FORMAT = "errCode: %d, errMsg: %s ";
    private int errCode;

    public DeserializationException(int errCode) {
        this.errCode = errCode;
    }

    public DeserializationException(int errCode, String errMsg) {
        super(String.format(ERROR_MESSAGE_FORMAT, errCode, errMsg));
        this.errCode = errCode;
    }

    public DeserializationException(int errCode, Throwable throwable) {
        super(throwable);
        this.errCode = errCode;
    }

    public DeserializationException(int errCode, String errMsg, Throwable throwable) {
        super(String.format(ERROR_MESSAGE_FORMAT, errCode, errMsg), throwable);
        this.errCode = errCode;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public DeserializationException() {
        new DeserializationException(101);
    }

    public DeserializationException(Class<?> targetClass) {
        new DeserializationException(101, String.format("Jackson deserialize for class [%s] failed. ", targetClass.getName()));
        this.targetClass = targetClass;
    }

    public DeserializationException(Type targetType) {
        new DeserializationException(101, String.format("Jackson deserialize for class [%s] failed. ", targetType.toString()));
    }

    public DeserializationException(Throwable throwable) {
        new DeserializationException(101, " deserialize failed. ", throwable);
    }

    public DeserializationException(Class<?> targetClass, Throwable throwable) {
        new DeserializationException(101, String.format("Jackson deserialize for class [%s] failed. ", targetClass.getName()), throwable);
        this.targetClass = targetClass;
    }

    public DeserializationException(Type targetType, Throwable throwable) {
        new DeserializationException(101, String.format("Jackson deserialize for class [%s] failed. ", targetType.toString()), throwable);
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }
}

