/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.executor;

import cn.xphsc.openstack.core.exception.OpenstackException;
import cn.xphsc.openstack.core.executor.AbstractExecutor;
import cn.xphsc.openstack.core.lambda.LambdaSupplier;
import cn.xphsc.openstack.utils.Strings;
import java.util.Map;

public class ClientApiExecutor<T>
extends AbstractExecutor<T> {
    private String clientModeName;
    private T entity;
    private Map headers;

    public ClientApiExecutor(LambdaSupplier client, ClientMode clientMode) {
        super(client);
        this.clientModeName = clientMode.name();
    }

    public ClientApiExecutor(LambdaSupplier client, Map headers, ClientMode clientMode) {
        super(client);
        this.clientModeName = clientMode.name();
        this.headers = headers;
    }

    @Override
    protected T doExecute() throws OpenstackException {
        if (Strings.isNotBlank(this.clientModeName)) {
            switch (this.clientModeName) {
                case "TOKEN": {
                    this.entity = this.client.getToken();
                    break;
                }
                case "IDENTITY": {
                    this.entity = this.client.identity();
                    break;
                }
                case "OBJECTSTORAGE": {
                    this.entity = this.client.objectStorage();
                    break;
                }
                case "NETWORKING": {
                    this.entity = this.client.networking();
                    break;
                }
                case "COMPUTE": {
                    this.entity = this.client.compute();
                    break;
                }
                case "MURANO": {
                    this.entity = this.client.murano();
                    break;
                }
                case "MAGNUM": {
                    this.entity = this.client.magnum();
                    break;
                }
                case "HEAT": {
                    this.entity = this.client.heat();
                    break;
                }
                case "DNS": {
                    this.entity = this.client.dns();
                    break;
                }
                case "ARTIFACT": {
                    this.entity = this.client.artifact();
                    break;
                }
                case "SAHARA": {
                    this.entity = this.client.sahara();
                    break;
                }
                case "SENLIN": {
                    this.entity = this.client.senlin();
                    break;
                }
                case "NETWORK": {
                    this.entity = this.client.networking().network();
                    break;
                }
                case "SUBNET": {
                    this.entity = this.client.networking().subnet();
                    break;
                }
                case "OCTAVIA": {
                    this.entity = this.client.octavia();
                    break;
                }
                case "TACKER": {
                    this.entity = this.client.tacker();
                    break;
                }
                case "BLOCKSTORAGE": {
                    this.entity = this.client.blockStorage();
                    break;
                }
                case "IMAGES": {
                    this.entity = this.client.images();
                    break;
                }
                case "IMAGESV2": {
                    this.entity = this.client.imagesV2();
                    break;
                }
                case "TELEMETRY": {
                    this.entity = this.client.telemetry();
                    break;
                }
                case "SHARE": {
                    this.entity = this.client.share();
                    break;
                }
                case "WORKFLOW": {
                    this.entity = this.client.workflow();
                    break;
                }
                case "GBP": {
                    this.entity = this.client.gbp();
                    break;
                }
                case "TROVE": {
                    this.entity = this.client.trove();
                    break;
                }
                case "BARBICAN": {
                    this.entity = this.client.barbican();
                    break;
                }
                case "HEADERS": {
                    this.entity = this.client.headers(this.headers);
                    break;
                }
            }
        }
        return this.entity;
    }

    public static enum ClientMode {
        TOKEN,
        IDENTITY,
        OBJECTSTORAGE,
        NETWORKING,
        COMPUTE,
        MURANO,
        MAGNUM,
        HEAT,
        DNS,
        ARTIFACT,
        SAHARA,
        SENLIN,
        NETWORK,
        SUBNET,
        OCTAVIA,
        TACKER,
        BLOCKSTORAGE,
        IMAGES,
        IMAGESV2,
        TELEMETRY,
        SHARE,
        WORKFLOW,
        GBP,
        TROVE,
        BARBICAN,
        HEADERS,
        NULL;

        private String name;

        private ClientMode() {
        }

        private ClientMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

