/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.executor;

import cn.xphsc.openstack.core.client.Apis;
import cn.xphsc.openstack.core.client.compute.external.impl.ImageV3ServiceImpl;
import cn.xphsc.openstack.core.exception.OpenstackException;
import cn.xphsc.openstack.core.executor.AbstractExecutor;
import cn.xphsc.openstack.core.lambda.LambdaSupplier;
import cn.xphsc.openstack.utils.Strings;
import org.openstack4j.api.OSClient;

public class NativeExternalApiExecutor<T>
extends AbstractExecutor<T> {
    private String nativeMode;
    private T entity;

    public NativeExternalApiExecutor(LambdaSupplier<OSClient.OSClientV3> client, NativeMode nativeMode) {
        super(client);
        this.nativeMode = nativeMode.name();
    }

    @Override
    protected T doExecute() throws OpenstackException {
        if (Strings.isNotBlank(this.nativeMode)) {
            switch (this.nativeMode) {
                case "APPCONTAINER": {
                    this.entity = this.client.appcontainer();
                    break;
                }
                case "APPCONTAINERQUOTA": {
                    this.entity = this.client.appcontainerQuota();
                    break;
                }
                case "APPCUSTOMCONTAINER": {
                    this.entity = Apis.appcontainerService();
                    break;
                }
                case "APPCUSTOMCONTAINERQUOTA": {
                    this.entity = Apis.appContainerQuotaService();
                    break;
                }
                case "T2GATEWAY": {
                    this.entity = this.client.l2gateway();
                    break;
                }
                case "T2GATEWAYCONNECTION": {
                    this.entity = this.client.l2gatewayConnection();
                    break;
                }
                case "VPN": {
                    this.entity = this.client.vpn();
                    break;
                }
                case "CUSTOMVPN": {
                    this.entity = Apis.vpnService();
                    break;
                }
                case "IMAGE3": {
                    ImageV3ServiceImpl imageV3Service = new ImageV3ServiceImpl(this.getClient());
                    this.entity = imageV3Service;
                    break;
                }
            }
        }
        return this.entity;
    }

    public static enum NativeMode {
        APPCONTAINER,
        APPCUSTOMCONTAINER,
        APPCONTAINERQUOTA,
        APPCUSTOMCONTAINERQUOTA,
        T2GATEWAY,
        T2GATEWAYCONNECTION,
        VPN,
        CUSTOMVPN,
        IMAGE3,
        NULL;

        private String name;

        private NativeMode() {
        }

        private NativeMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

