/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;

public class ContainerBody {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="image")
    private String image = null;
    @JsonProperty(value="port_id")
    private String portId = null;
    @JsonProperty(value="security_groups")
    private List<String> securityGroups = null;
    @JsonProperty(value="privileged")
    private Boolean privileged = null;
    @JsonProperty(value="image_driver")
    private ImageDriver imageDriver = null;
    @JsonProperty(value="network_id")
    private String networkId = null;
    @JsonProperty(value="external")
    private Boolean external = null;
    @JsonProperty(value="floating_ip")
    private String floatingIp = null;
    @JsonProperty(value="external_network_name")
    private String externalNetworkName = null;
    @JsonProperty(value="cmd")
    private String cmd;
    @JsonProperty(value="cpu")
    private Float cpu;
    @JsonProperty(value="memory")
    private String memory;
    private String restartPolicy;

    public static Builder builder() {
        return new Builder();
    }

    private ContainerBody(Builder builder) {
        this.name = builder.name;
        this.image = builder.image;
        this.portId = builder.portId;
        this.securityGroups = builder.securityGroups;
        this.privileged = builder.privileged;
        this.imageDriver = builder.imageDriver;
        this.networkId = builder.networkId;
        this.external = builder.external;
        this.floatingIp = builder.floatingIp;
        this.externalNetworkName = builder.externalNetworkName;
        this.cmd = builder.cmd;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.restartPolicy = builder.restartPolicy;
    }

    public String getName() {
        return this.name;
    }

    public String getImage() {
        return this.image;
    }

    public String getPortId() {
        return this.portId;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public ImageDriver getImageDriver() {
        return this.imageDriver;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public Boolean getExternal() {
        return this.external;
    }

    public String getFloatingIp() {
        return this.floatingIp;
    }

    public String getExternalNetworkName() {
        return this.externalNetworkName;
    }

    public String getCmd() {
        return this.cmd;
    }

    public Float getCpu() {
        return this.cpu;
    }

    public String getMemory() {
        return this.memory;
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public static enum ImageDriver {
        GLANCE("glance"),
        DOCKER("docker");

        private String value;

        private ImageDriver(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ImageDriver fromValue(String text) {
            for (ImageDriver b : ImageDriver.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static class Builder {
        private String name = null;
        private String image = null;
        private String portId = null;
        private List<String> securityGroups = null;
        private Boolean privileged = null;
        private ImageDriver imageDriver = null;
        private String networkId = null;
        private Boolean external = null;
        private String floatingIp = null;
        private String externalNetworkName = null;
        private String cmd;
        private Float cpu;
        private String memory;
        private String restartPolicy;

        public <T> Builder name(String name) {
            this.name = name;
            return this;
        }

        public <T> Builder image(String image) {
            this.image = image;
            return this;
        }

        public <T> Builder portId(String portId) {
            this.portId = portId;
            return this;
        }

        public <T> Builder securityGroups(List<String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public <T> Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public <T> Builder imageDriver(ImageDriver imageDriver) {
            this.imageDriver = imageDriver;
            return this;
        }

        public <T> Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public <T> Builder external(Boolean external) {
            this.external = external;
            return this;
        }

        public <T> Builder floatingIp(String floatingIp) {
            this.floatingIp = floatingIp;
            return this;
        }

        public <T> Builder externalNetworkName(String externalNetworkName) {
            this.externalNetworkName = externalNetworkName;
            return this;
        }

        public <T> Builder cmd(String cmd) {
            this.cmd = cmd;
            return this;
        }

        public <T> Builder cpu(Float cpu) {
            this.cpu = cpu;
            return this;
        }

        public <T> Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public <T> Builder restartPolicy(String restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        public ContainerBody build() {
            return new ContainerBody(this);
        }
    }
}

