/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.core.support;

import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.core.transport.Config;
import org.openstack4j.model.common.Identifier;
import org.openstack4j.openstack.OSFactory;
import org.springframework.util.StringUtils;

public class OpenstackAccessor {
    private String cloudUri;
    private String username;
    private String userId;
    private String password;
    private String projectName;
    private String domainName;
    private String projectId;
    private String token;
    private OSClient.OSClientV3 osClient;
    private int connectionTimeout = 60000;
    private int readTimeout = 300000;
    private int maxConnections = 1000;
    private int waitTimeout = 5;
    private int intervalTime = 10;

    public OSClient.OSClientV3 initOpenstackClient() {
        IOSClientBuilder.V3 os = OSFactory.builderV3();
        os.endpoint(this.cloudUri);
        if (!(StringUtils.isEmpty((Object)this.username) || StringUtils.isEmpty((Object)this.password) || StringUtils.isEmpty((Object)this.domainName))) {
            os.credentials(this.username, this.password, Identifier.byName((String)this.domainName));
        }
        if (!StringUtils.isEmpty((Object)this.userId) && !StringUtils.isEmpty((Object)this.password)) {
            ((IOSClientBuilder.V3)os.endpoint(this.cloudUri)).credentials(this.userId, this.password);
        }
        if (!StringUtils.isEmpty((Object)this.projectName) && !StringUtils.isEmpty((Object)this.domainName)) {
            os.scopeToProject(Identifier.byName((String)this.projectName), Identifier.byName((String)this.domainName));
        }
        if (!StringUtils.isEmpty((Object)this.projectId)) {
            os.scopeToProject(Identifier.byId((String)this.projectId));
        }
        if (!StringUtils.isEmpty((Object)this.token)) {
            os.token(this.token);
        }
        os.withConfig(Config.newConfig().withConnectionTimeout(this.connectionTimeout).withReadTimeout(this.readTimeout).withMaxConnections(this.maxConnections));
        this.osClient = (OSClient.OSClientV3)os.authenticate();
        return this.osClient;
    }

    public String getCloudUri() {
        return this.cloudUri;
    }

    public void setCloudUri(String cloudUri) {
        this.cloudUri = cloudUri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(int waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    public int getIntervalTime() {
        return this.intervalTime;
    }

    public void setIntervalTime(int intervalTime) {
        this.intervalTime = intervalTime;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}

