/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.openstack.utils;

import cn.xphsc.openstack.core.exception.DeserializationException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;

public class Jacksons {
    static ObjectMapper mapper = new ObjectMapper();

    public static String toJSONString(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException var2) {
            throw new DeserializationException(obj.getClass(), (Throwable)var2);
        }
    }

    public static String toJSONString(Object obj, boolean writeNullValue) {
        try {
            return writeNullValue ? mapper.setSerializationInclusion(JsonInclude.Include.USE_DEFAULTS).writeValueAsString(obj) : mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException var2) {
            throw new DeserializationException(obj.getClass(), (Throwable)var2);
        }
    }

    public static <T> T toJsonObject(InputStream inputStream, Class<T> cls) {
        try {
            return (T)mapper.readValue(inputStream, cls);
        }
        catch (IOException var3) {
            throw new DeserializationException(var3);
        }
    }

    public static <T> T toJsonObject(String json, Class<T> cls) {
        try {
            return (T)mapper.readValue(json, cls);
        }
        catch (IOException var3) {
            throw new DeserializationException(cls, (Throwable)var3);
        }
    }

    public static <T> T toJsonObject(String json, Class<T> cls, boolean writeNullValue) {
        try {
            if (writeNullValue) {
                return (T)mapper.setSerializationInclusion(JsonInclude.Include.USE_DEFAULTS).readValue(json, cls);
            }
            return (T)mapper.readValue(json, cls);
        }
        catch (IOException var3) {
            throw new DeserializationException(cls, (Throwable)var3);
        }
    }

    public static <T> T toJsonObject(String json, Type type) {
        try {
            return (T)mapper.readValue(json, mapper.constructType(type));
        }
        catch (IOException var3) {
            throw new DeserializationException(var3);
        }
    }

    public static <T> T toJsonObject(String json, TypeReference<T> typeReference) {
        try {
            return (T)mapper.readValue(json, typeReference);
        }
        catch (IOException var3) {
            throw new DeserializationException(typeReference.getClass(), (Throwable)var3);
        }
    }

    public static <T> T toJsonObject(InputStream inputStream, Type type) {
        try {
            return (T)mapper.readValue(inputStream, mapper.constructType(type));
        }
        catch (IOException var3) {
            throw new DeserializationException(type, (Throwable)var3);
        }
    }

    public static JsonNode toJsonObject(String json) {
        try {
            return mapper.readTree(json);
        }
        catch (IOException var2) {
            throw new DeserializationException(var2);
        }
    }

    public static void registerSubtype(Class<?> clz, String type) {
        mapper.registerSubtypes(new NamedType[]{new NamedType(clz, type)});
    }

    public static ObjectNode createEmptyJsonNode() {
        return new ObjectNode(mapper.getNodeFactory());
    }

    public static ArrayNode createEmptyArrayNode() {
        return new ArrayNode(mapper.getNodeFactory());
    }

    public static JsonNode transferToJsonNode(Object obj) {
        return mapper.valueToTree(obj);
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

