/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.container;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.common.BasicResource;
import org.openstack4j.openstack.common.GenericLink;
import org.openstack4j.openstack.container.domain.ZunAppContainerAddress;
import org.openstack4j.openstack.container.domain.ZunContainerHealthcheck;

public interface AppContainer
extends BasicResource {
    public String getName();

    public String getImage();

    public String getImageDriver();

    public List<String> getCommand();

    public String getStatus();

    public String getStatusReason();

    public String getTaskState();

    public Float getCpu();

    public Integer getMemory();

    public String getWorkdir();

    public List<String> getPorts();

    public String getHost();

    public Map<String, String> getEnvironment();

    public Map<String, String> getLabels();

    public Map<String, List<ZunAppContainerAddress>> getAddresses();

    public List<String> getSecurityGroups();

    public Map<String, Object> getRestartPolicy();

    public String getStatusDetail();

    public Boolean isInteractive();

    public Boolean isAutoRemove();

    public String getImagePullPolicy();

    public String getCreatedAt();

    public String getUpdatedAt();

    public List<GenericLink> getLinks();

    public Boolean getTty();

    public String getHostname();

    public Boolean getAutoHeal();

    public Boolean getPrivileged();

    public String getUserId();

    public String getProjectId();

    public Integer getDisk();

    public ZunContainerHealthcheck getHealthcheck();

    public String getRegistryId();

    public CpuPolicy getCpuPolicy();

    public List<String> getEntrypoint();

    public static enum CpuPolicy {
        SHARED,
        DEDICATED,
        UNKNOWN;


        @JsonCreator
        public static CpuPolicy forValue(String value) {
            if (value != null) {
                for (CpuPolicy s : CpuPolicy.values()) {
                    if (!s.name().equalsIgnoreCase(value)) continue;
                    return s;
                }
            }
            return UNKNOWN;
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }

    public static enum MountType {
        VOLUME,
        BIND;


        @JsonCreator
        public static MountType forValue(String value) {
            if (value != null) {
                for (MountType s : MountType.values()) {
                    if (!s.name().equalsIgnoreCase(value)) continue;
                    return s;
                }
            }
            return VOLUME;
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }
}

