/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.container;

import java.util.List;
import java.util.Map;
import org.openstack4j.common.Buildable;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.container.AppContainerNets;
import org.openstack4j.model.container.Healthcheck;
import org.openstack4j.model.container.Mounts;
import org.openstack4j.model.container.builder.AppContainerCreateBuilder;

public interface AppContainerCreate
extends ModelEntity,
Buildable<AppContainerCreateBuilder> {
    public String getName();

    public String getImage();

    public List<String> getCommand();

    public String getMemory();

    public Float getCpu();

    public Map<String, String> getEnvironment();

    public String getWorkdir();

    public Map<String, String> getLabels();

    public String getImagePullPolicy();

    public Map<String, Object> getRestartPolicy();

    public Boolean isInteractive();

    public String getImageDriver();

    public List<String> getSecurityGroups();

    public Map<String, String> getHints();

    public List<AppContainerNets> getNets();

    public Boolean isAutoRemove();

    public String getRuntime();

    public String getHostname();

    public Boolean isAutoHeal();

    public String getAvailabilityZone();

    public Mounts getMounts();

    public Boolean isPrivileged();

    public Healthcheck getHealthcheck();

    public Map<String, Object> getExposedPorts();

    public String getHost();

    public List<String> getEntrypoint();

    public static enum ImageDriver {
        DOCKER,
        GLANCE,
        UNKNOWN;


        public static ImageDriver value(String value) {
            if (value == null) {
                return UNKNOWN;
            }
            for (ImageDriver driver : ImageDriver.values()) {
                if (!driver.name().equalsIgnoreCase(value)) continue;
                return driver;
            }
            return UNKNOWN;
        }

        public String value() {
            return this.name().toLowerCase();
        }
    }
}

