/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.container.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.container.AppContainer;
import org.openstack4j.openstack.common.GenericLink;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.container.domain.ZunAppContainerAddress;
import org.openstack4j.openstack.container.domain.ZunContainerHealthcheck;

public class ZunAppContainer
implements AppContainer {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="uuid")
    private String id;
    String name;
    String image;
    @JsonProperty(value="image_driver")
    String imageDriver;
    List<String> command;
    String status;
    @JsonProperty(value="status_reason")
    String statusReason;
    @JsonProperty(value="task_state")
    String taskState;
    Float cpu;
    String memory;
    String workdir;
    List<String> ports;
    String host;
    Map<String, String> environment;
    Map<String, String> labels;
    Map<String, List<ZunAppContainerAddress>> addresses;
    @JsonProperty(value="security_groups")
    List<String> securityGroups;
    @JsonProperty(value="restart_policy")
    Map<String, Object> restartPolicy;
    @JsonProperty(value="status_detail")
    String statusDetail;
    Boolean interactive;
    @JsonProperty(value="auto_remove")
    Boolean autoRemove;
    @JsonProperty(value="image_pull_policy")
    String imagePullPolicy;
    @JsonProperty(value="created_at")
    String createdAt;
    @JsonProperty(value="updated_at")
    String updatedAt;
    List<GenericLink> links;
    Boolean tty;
    String hostname;
    @JsonProperty(value="auto_heal")
    Boolean autoHeal;
    Boolean privileged;
    @JsonProperty(value="user_id")
    String userId;
    @JsonProperty(value="project_id")
    String projectId;
    Integer disk;
    ZunContainerHealthcheck healthcheck;
    @JsonProperty(value="cpu_policy")
    AppContainer.CpuPolicy cpuPolicy;
    @JsonProperty(value="registry_id")
    String registryId;
    List<String> entrypoint;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public String getImageDriver() {
        return this.imageDriver;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getStatusReason() {
        return this.statusReason;
    }

    @Override
    public String getTaskState() {
        return this.taskState;
    }

    @Override
    public Float getCpu() {
        return this.cpu;
    }

    @Override
    public Integer getMemory() {
        if (this.memory != null && !this.memory.isEmpty()) {
            try {
                String memUpper = this.memory.toUpperCase();
                if (memUpper.endsWith("G")) {
                    return Integer.parseInt(memUpper.substring(0, memUpper.length() - 1)) * 1024;
                }
                if (memUpper.endsWith("M")) {
                    return Integer.parseInt(memUpper.substring(0, memUpper.length() - 1));
                }
                return memUpper.endsWith("K") ? Math.round((float)Integer.parseInt(memUpper.substring(0, memUpper.length() - 1)) / 1024.0f) : Integer.parseInt(this.memory);
            }
            catch (NumberFormatException var2) {
                System.err.println("Failed to parse memory string: " + this.memory);
                return null;
            }
        }
        return null;
    }

    @Override
    public String getWorkdir() {
        return this.workdir;
    }

    @Override
    public List<String> getPorts() {
        return this.ports;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public Map<String, List<ZunAppContainerAddress>> getAddresses() {
        return this.addresses;
    }

    @Override
    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @Override
    public Map<String, Object> getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public String getStatusDetail() {
        return this.statusDetail;
    }

    @Override
    public Boolean isInteractive() {
        return this.interactive != null && this.interactive != false;
    }

    @Override
    public Boolean isAutoRemove() {
        return this.autoRemove != null && this.autoRemove != false;
    }

    @Override
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Override
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public List<GenericLink> getLinks() {
        return this.links;
    }

    @Override
    public Boolean getTty() {
        return this.tty;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public Boolean getAutoHeal() {
        return this.autoHeal;
    }

    @Override
    public Boolean getPrivileged() {
        return this.privileged;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public Integer getDisk() {
        return this.disk;
    }

    @Override
    public ZunContainerHealthcheck getHealthcheck() {
        return this.healthcheck;
    }

    @Override
    public String getRegistryId() {
        return this.registryId;
    }

    @Override
    public AppContainer.CpuPolicy getCpuPolicy() {
        return this.cpuPolicy;
    }

    @Override
    public List<String> getEntrypoint() {
        return this.entrypoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("image", (Object)this.image).add("imageDriver", (Object)this.imageDriver).add("command", this.command).add("workDir", (Object)this.workdir).add("hostname", (Object)this.hostname).add("imagePullPolicy", (Object)this.imagePullPolicy).add("cpu", (Object)this.cpu).add("memory", (Object)this.memory).add("privileged", (Object)this.privileged).add("interactive", (Object)this.interactive).add("autoRemove", (Object)this.autoRemove).add("securityGroups", this.securityGroups).add("environment", this.environment).add("label", this.labels).add("host", (Object)this.host).add("ports", this.ports).add("addresses", this.addresses).add("status", (Object)this.status).add("status_detail", (Object)this.statusDetail).toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static class ZunContainers
    extends ListResult<ZunAppContainer> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="containers")
        List<ZunAppContainer> list;

        protected List<ZunAppContainer> value() {
            return this.list;
        }
    }
}

