/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.container.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.openstack4j.model.container.AppContainerAddress;
import org.openstack4j.model.container.builder.AppContainerAddressBuilder;

public class ZunAppContainerAddress
implements AppContainerAddress {
    @JsonProperty(value="subnet_id")
    private String subnetId;
    private String addr;
    private String port;
    @JsonProperty(value="preserve_on_delete")
    private String preserveOnDelete;
    private Integer version;

    @Override
    public String getSubnetId() {
        return this.subnetId;
    }

    @Override
    public String getAddr() {
        return this.addr;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public String getPreserveOnDelete() {
        return this.preserveOnDelete;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public AppContainerAddressBuilder toBuilder() {
        return new AddressBuilderImpl(this);
    }

    public static AppContainerAddressBuilder builder() {
        return new AddressBuilderImpl();
    }

    public static class AddressBuilderImpl
    implements AppContainerAddressBuilder {
        private ZunAppContainerAddress model;

        public AddressBuilderImpl() {
            this(new ZunAppContainerAddress());
        }

        public AddressBuilderImpl(ZunAppContainerAddress model) {
            this.model = model;
        }

        @Override
        public AppContainerAddressBuilder subnetId(String subnetId) {
            this.model.subnetId = subnetId;
            return this;
        }

        @Override
        public AppContainerAddressBuilder addr(String addr) {
            this.model.addr = addr;
            return this;
        }

        @Override
        public AppContainerAddressBuilder port(String port) {
            this.model.port = port;
            return this;
        }

        @Override
        public AppContainerAddressBuilder preserveOnDelete(Boolean preserveOnDelete) {
            this.model.preserveOnDelete = preserveOnDelete.toString();
            return this;
        }

        @Override
        public AppContainerAddressBuilder version(Integer version) {
            this.model.version = version;
            return this;
        }

        public AppContainerAddress build() {
            return this.model;
        }

        public AppContainerAddressBuilder from(AppContainerAddress in) {
            this.model = (ZunAppContainerAddress)in;
            return this;
        }
    }
}

