/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.container.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.container.AppContainerCreate;
import org.openstack4j.model.container.AppContainerNets;
import org.openstack4j.model.container.Healthcheck;
import org.openstack4j.model.container.Mounts;
import org.openstack4j.model.container.builder.AppContainerCreateBuilder;
import org.openstack4j.openstack.container.domain.ZunContainerHealthcheck;
import org.openstack4j.openstack.container.domain.ZunContainerMounts;
import org.openstack4j.openstack.container.domain.ZunContainerNets;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ZunAppContainerCreate
implements AppContainerCreate {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="image")
    String image;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="command")
    List<String> command;
    @JsonProperty(value="memory")
    String memory;
    @JsonProperty(value="cpu")
    Float cpu;
    @JsonProperty(value="environment")
    Map<String, String> environment;
    @JsonProperty(value="workdir")
    String workdir;
    @JsonProperty(value="labels")
    Map<String, String> labels;
    @JsonProperty(value="image_pull_policy")
    String imagePullPolicy;
    @JsonProperty(value="restart_policy")
    Map<String, Object> restartPolicy;
    @JsonProperty(value="interactive")
    Boolean interactive;
    @JsonProperty(value="image_driver")
    String imageDriver;
    @JsonProperty(value="security_groups")
    List<String> securityGroups;
    @JsonProperty(value="hints")
    Map<String, String> hints;
    @JsonProperty(value="nets")
    List<AppContainerNets> nets;
    @JsonProperty(value="runtime")
    String runtime;
    @JsonProperty(value="hostname")
    String hostname;
    @JsonProperty(value="auto_remove")
    Boolean autoRemove;
    @JsonProperty(value="auto_heal")
    Boolean autoHeal;
    @JsonProperty(value="availability_zone")
    String availabilityZone;
    String host;
    ZunContainerMounts mounts;
    Boolean privileged;
    ZunContainerHealthcheck healthcheck;
    @JsonProperty(value="exposed_ports")
    Map<String, Object> exposedPorts;
    List<String> entrypoint;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String getMemory() {
        return this.memory;
    }

    @Override
    public Float getCpu() {
        return this.cpu;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    public String getWorkdir() {
        return this.workdir;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Override
    public Map<String, Object> getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public Boolean isInteractive() {
        return this.interactive;
    }

    @Override
    public String getImageDriver() {
        return this.imageDriver;
    }

    @Override
    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @Override
    public Map<String, String> getHints() {
        return this.hints;
    }

    @Override
    public List<AppContainerNets> getNets() {
        return this.nets;
    }

    @Override
    public Boolean isAutoRemove() {
        return this.autoRemove;
    }

    @Override
    public String getRuntime() {
        return this.runtime;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public Boolean isAutoHeal() {
        return this.autoHeal;
    }

    @Override
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    @Override
    public ZunContainerMounts getMounts() {
        return this.mounts;
    }

    @Override
    public Boolean isPrivileged() {
        return this.privileged;
    }

    @Override
    public ZunContainerHealthcheck getHealthcheck() {
        return this.healthcheck;
    }

    @Override
    public Map<String, Object> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public List<String> getEntrypoint() {
        return this.entrypoint;
    }

    public static AppContainerCreateBuilder builder() {
        return new ConcreteContainerCreateBuilder();
    }

    public AppContainerCreateBuilder toBuilder() {
        return new ConcreteContainerCreateBuilder(this);
    }

    public static class ConcreteContainerCreateBuilder
    implements AppContainerCreateBuilder {
        private ZunAppContainerCreate model;

        ConcreteContainerCreateBuilder() {
            this(new ZunAppContainerCreate());
        }

        ConcreteContainerCreateBuilder(ZunAppContainerCreate model) {
            this.model = model;
            if (this.model.environment == null) {
                this.model.environment = new HashMap<String, String>();
            }
            if (this.model.labels == null) {
                this.model.labels = new HashMap<String, String>();
            }
            if (this.model.securityGroups == null) {
                this.model.securityGroups = new ArrayList<String>();
            }
            if (this.model.hints == null) {
                this.model.hints = new HashMap<String, String>();
            }
            if (this.model.nets == null) {
                this.model.nets = new ArrayList<AppContainerNets>();
            }
        }

        @Override
        public AppContainerCreateBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public AppContainerCreateBuilder image(String image) {
            this.model.image = image;
            return this;
        }

        @Override
        public AppContainerCreateBuilder command(List<String> command) {
            this.model.command = command;
            return this;
        }

        @Override
        public AppContainerCreateBuilder command(String command) {
            if (this.model.command == null) {
                this.model.command = new ArrayList<String>();
            }
            this.model.command.addAll(Arrays.asList(command.split("\\s+")));
            return this;
        }

        @Override
        public AppContainerCreateBuilder memory(String memory) {
            this.model.memory = memory;
            return this;
        }

        @Override
        public AppContainerCreateBuilder cpu(Float cpu) {
            this.model.cpu = cpu;
            return this;
        }

        @Override
        public AppContainerCreateBuilder environment(Map<String, String> environment) {
            this.model.environment = environment;
            return this;
        }

        @Override
        public AppContainerCreateBuilder addEnvironment(String key, String value) {
            if (this.model.environment == null) {
                this.model.environment = new HashMap<String, String>();
            }
            this.model.environment.put(key, value);
            return this;
        }

        @Override
        public AppContainerCreateBuilder workdir(String workdir) {
            this.model.workdir = workdir;
            return this;
        }

        @Override
        public AppContainerCreateBuilder labels(Map<String, String> labels) {
            this.model.labels = labels;
            return this;
        }

        @Override
        public AppContainerCreateBuilder addLabel(String key, String value) {
            if (this.model.labels == null) {
                this.model.labels = new HashMap<String, String>();
            }
            this.model.labels.put(key, value);
            return this;
        }

        @Override
        public AppContainerCreateBuilder imagePullPolicy(String policy) {
            this.model.imagePullPolicy = policy;
            return this;
        }

        @Override
        public AppContainerCreateBuilder restartPolicy(String name, int maxRetryCount) {
            this.model.restartPolicy = ImmutableMap.of((Object)"Name", (Object)name, (Object)"MaximumRetryCount", (Object)maxRetryCount);
            return this;
        }

        @Override
        public AppContainerCreateBuilder interactive(boolean interactive) {
            this.model.interactive = interactive;
            return this;
        }

        @Override
        public AppContainerCreateBuilder imageDriver(AppContainerCreate.ImageDriver imageDriver) {
            this.model.imageDriver = imageDriver.value();
            return this;
        }

        @Override
        public AppContainerCreateBuilder securityGroups(List<String> securityGroups) {
            this.model.securityGroups = securityGroups;
            return this;
        }

        @Override
        public AppContainerCreateBuilder addSecurityGroup(String securityGroupIdOrName) {
            if (this.model.securityGroups == null) {
                this.model.securityGroups = new ArrayList<String>();
            }
            this.model.securityGroups.add(securityGroupIdOrName);
            return this;
        }

        @Override
        public AppContainerCreateBuilder hints(Map<String, String> hints) {
            this.model.hints = hints;
            return this;
        }

        @Override
        public AppContainerCreateBuilder addHint(String key, String value) {
            if (this.model.hints == null) {
                this.model.hints = new HashMap<String, String>();
            }
            this.model.hints.put(key, value);
            return this;
        }

        @Override
        public AppContainerCreateBuilder nets(List<AppContainerNets> nets) {
            this.model.nets = nets;
            return this;
        }

        @Override
        public AppContainerCreateBuilder addNet(String networkId) {
            if (this.model.nets == null) {
                this.model.nets = new ArrayList<AppContainerNets>();
            }
            this.model.nets.add((AppContainerNets)ZunContainerNets.builder().network(networkId).build());
            return this;
        }

        @Override
        public AppContainerCreateBuilder addNetPort(String portId) {
            if (this.model.nets == null) {
                this.model.nets = new ArrayList<AppContainerNets>();
            }
            this.model.nets.add((AppContainerNets)ZunContainerNets.builder().port(portId).build());
            return this;
        }

        @Override
        public AppContainerCreateBuilder autoRemove(boolean autoRemove) {
            this.model.autoRemove = autoRemove;
            return this;
        }

        @Override
        public AppContainerCreateBuilder runtime(String runtime) {
            this.model.runtime = runtime;
            return this;
        }

        @Override
        public AppContainerCreateBuilder hostname(String hostname) {
            this.model.hostname = hostname;
            return this;
        }

        @Override
        public AppContainerCreateBuilder autoHeal(boolean autoHeal) {
            this.model.autoHeal = autoHeal;
            return this;
        }

        @Override
        public AppContainerCreateBuilder availabilityZone(String availabilityZone) {
            this.model.availabilityZone = availabilityZone;
            return this;
        }

        @Override
        public AppContainerCreateBuilder mounts(Mounts mounts) {
            this.model.mounts = (ZunContainerMounts)mounts;
            return this;
        }

        @Override
        public AppContainerCreateBuilder privileged(boolean privileged) {
            this.model.privileged = privileged;
            return this;
        }

        @Override
        public AppContainerCreateBuilder healthcheck(Healthcheck healthcheck) {
            this.model.healthcheck = (ZunContainerHealthcheck)healthcheck;
            return this;
        }

        @Override
        public AppContainerCreateBuilder exposedPorts(Map<String, Object> exposedPorts) {
            this.model.exposedPorts = exposedPorts;
            return this;
        }

        @Override
        public AppContainerCreateBuilder host(String host) {
            this.model.host = host;
            return this;
        }

        @Override
        public AppContainerCreateBuilder entrypoint(List<String> entrypoint) {
            this.model.entrypoint = entrypoint;
            return this;
        }

        public AppContainerCreate build() {
            Preconditions.checkNotNull((Object)this.model.image, (Object)"Image must be set");
            return this.model;
        }

        public AppContainerCreateBuilder from(AppContainerCreate in) {
            this.model = (ZunAppContainerCreate)in;
            return this;
        }
    }
}

